/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Doubles;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class ParseFloatFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction {
    @Inject
    ParseFloatFunction() {
    }

    @Override
    public String getName() {
        return "parseFloat";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of(Integer.valueOf(1));
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        Double d = Doubles.tryParse(args.get(0).stringValue());
        return d == null || d.isNaN() ? NullData.INSTANCE : FloatData.forValue(d);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg = args.get(0).getText();
        return new JsExpr(String.format("soy.$$parseFloat(%s)", arg), Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of("soy");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return new PyExpr(String.format("runtime.parse_float(%s)", args.get(0).getText()), Integer.MAX_VALUE);
    }
}

