/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.HashMap;
import javax.annotation.Nullable;

final class CompiledTemplateRegistry {
    private final ImmutableBiMap<String, CompiledTemplateMetadata> templateNameToMetadata;
    private final ImmutableBiMap<String, CompiledTemplateMetadata> classNameToMetadata;
    private final ImmutableMap<String, Optional<SanitizedContent.ContentKind>> deltemplateNameToContentKind;
    private final ImmutableSet<String> delegateTemplateNames;

    CompiledTemplateRegistry(TemplateRegistry registry) {
        HashMap<String, Optional<SanitizedContent.ContentKind>> deltemplateNameToContentKind = new HashMap<String, Optional<SanitizedContent.ContentKind>>();
        ImmutableBiMap.Builder templateToMetadata = ImmutableBiMap.builder();
        ImmutableBiMap.Builder classToMetadata = ImmutableBiMap.builder();
        ImmutableSet.Builder delegateTemplateNames = ImmutableSet.builder();
        for (TemplateNode template : registry.getAllTemplates()) {
            CompiledTemplateMetadata metadata = CompiledTemplateMetadata.create(template.getTemplateName(), template);
            templateToMetadata.put(template.getTemplateName(), metadata);
            classToMetadata.put(metadata.typeInfo().className(), metadata);
            if (!(template instanceof TemplateDelegateNode)) continue;
            delegateTemplateNames.add(template.getTemplateName());
            deltemplateNameToContentKind.put(((TemplateDelegateNode)template).getDelTemplateName(), Optional.fromNullable(template.getContentKind()));
        }
        this.templateNameToMetadata = templateToMetadata.build();
        this.classNameToMetadata = classToMetadata.build();
        this.deltemplateNameToContentKind = ImmutableMap.copyOf(deltemplateNameToContentKind);
        this.delegateTemplateNames = delegateTemplateNames.build();
    }

    ImmutableSet<String> getTemplateNames() {
        return this.templateNameToMetadata.keySet();
    }

    ImmutableSet<String> getDelegateTemplateNames() {
        return this.delegateTemplateNames;
    }

    CompiledTemplateMetadata getTemplateInfoByTemplateName(String templateName) {
        return (CompiledTemplateMetadata)this.templateNameToMetadata.get(templateName);
    }

    CompiledTemplateMetadata getTemplateInfoByClassName(String templateName) {
        return (CompiledTemplateMetadata)this.classNameToMetadata.get(templateName);
    }

    @Nullable
    SanitizedContent.ContentKind getDelTemplateContentKind(String delTemplateName) {
        return this.deltemplateNameToContentKind.get(delTemplateName).orNull();
    }

    boolean hasDelTemplateDefinition(String delTemplateName) {
        return this.deltemplateNameToContentKind.containsKey(delTemplateName);
    }
}

