/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jbcsrc.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.ClassData;

final class MemoryClassLoader
extends AbstractMemoryClassLoader {
    private final ImmutableMap<String, ClassData> classesByName;

    MemoryClassLoader(Iterable<ClassData> classes) {
        this.classesByName = MemoryClassLoader.indexByClassname(classes);
    }

    MemoryClassLoader(ClassLoader parent, Iterable<ClassData> classes) {
        super(parent);
        this.classesByName = MemoryClassLoader.indexByClassname(classes);
    }

    @Override
    ClassData getClassData(String name) {
        return this.classesByName.get(name);
    }

    private static ImmutableMap<String, ClassData> indexByClassname(Iterable<ClassData> classes) {
        ImmutableMap.Builder<String, ClassData> builder = ImmutableMap.builder();
        for (ClassData classData : classes) {
            builder.put(classData.type().className(), classData);
        }
        return builder.build();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

