/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class Window
extends AbstractLoggingBean
implements Channel,
ChannelHolder {
    public static final Predicate<Window> SPACE_AVAILABLE_PREDICATE = input -> input.sizeHolder.get() > 0L;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicLong sizeHolder = new AtomicLong(0L);
    private final AbstractChannel channelInstance;
    private final Object lock;
    private final String suffix;
    private long maxSize;
    private long packetSize;

    public Window(AbstractChannel channel, Object lock, boolean client, boolean local) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel provided");
        this.lock = lock != null ? lock : this;
        this.suffix = (client ? "client" : "server") + "/" + (local ? "local" : "remote");
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.sizeHolder.get();
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public void init(PropertyResolver resolver) {
        this.init(resolver.getLongProperty("window-size", 0x200000L), resolver.getLongProperty("packet-size", 32768L), resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long size, long packetSize, PropertyResolver resolver) {
        BufferUtils.validateUint32Value(size, "Illegal initial size: %d");
        BufferUtils.validateUint32Value(packetSize, "Illegal packet size: %d");
        ValidateUtils.checkTrue(packetSize > 0L, "Packet size must be positive: %d", packetSize);
        long limitPacketSize = resolver.getLongProperty("max-packet-size", 0x1FFFFFFFL);
        if (packetSize > limitPacketSize) {
            throw new IllegalArgumentException("Requested packet size (" + packetSize + ") exceeds max. allowed: " + limitPacketSize);
        }
        Object object = this.lock;
        synchronized (object) {
            this.maxSize = size;
            this.packetSize = packetSize;
            this.updateSize(size);
        }
        if (this.initialized.getAndSet(true) && this.log.isDebugEnabled()) {
            this.log.debug("init({}) re-initializing", (Object)this);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({}) size={}, max={}, packet={}", this, this.getSize(), this.getMaxSize(), this.getPacketSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int window) {
        long expandedSize;
        ValidateUtils.checkTrue(window >= 0, "Negative window size: %d", window);
        this.checkInitialized("expand");
        Object object = this.lock;
        synchronized (object) {
            expandedSize = this.sizeHolder.get() + (long)window;
            if (expandedSize > 0xFFFFFFFFL) {
                this.updateSize(0xFFFFFFFFL);
            } else {
                this.updateSize(expandedSize);
            }
        }
        if (expandedSize > Integer.MAX_VALUE) {
            this.log.warn("expand({}) window={} - truncated expanded size ({}) to {}", this, window, expandedSize, Integer.MAX_VALUE);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", this, window, expandedSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(long len) {
        long remainLen;
        BufferUtils.validateUint32Value(len, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            remainLen = this.sizeHolder.get() - len;
            if (remainLen >= 0L) {
                this.updateSize(remainLen);
            }
        }
        if (remainLen < 0L) {
            throw new IllegalStateException("consume(" + this + ") required length (" + len + ") above available: " + (remainLen + len));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Consume {} by {} down to {}", this, len, remainLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAndCheck(long len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.consume(len);
                this.check(this.maxSize);
            }
            catch (RuntimeException e) {
                throw new StreamCorruptedException("consumeAndCheck(" + this + ")" + " failed (" + e.getClass().getSimpleName() + ")" + " to consume " + len + " bytes" + ": " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(long maxFree) throws IOException {
        BufferUtils.validateUint32Value(maxFree, "Invalid check size: %d");
        this.checkInitialized("check");
        long adjustSize = -1L;
        AbstractChannel channel = this.getChannel();
        Object object = this.lock;
        synchronized (object) {
            long size = this.sizeHolder.get();
            if (size < maxFree / 2L) {
                adjustSize = maxFree - size;
                channel.sendWindowAdjust(adjustSize);
                this.updateSize(maxFree);
            }
        }
        if (adjustSize >= 0L && this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", this, adjustSize, maxFree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(long len, long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        BufferUtils.validateUint32Value(len, "Invalid wait consume length: %d", (Object)len);
        this.checkInitialized("waitAndConsume");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(input -> input.sizeHolder.get() >= len, maxWaitTime);
            if (this.log.isDebugEnabled()) {
                this.log.debug("waitAndConsume({}) - requested={}, available={}", this, len, this.sizeHolder);
            }
            this.consume(len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForSpace(long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        long available;
        this.checkInitialized("waitForSpace");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(SPACE_AVAILABLE_PREDICATE, maxWaitTime);
            available = this.sizeHolder.get();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("waitForSpace({}) available: {}", (Object)this, (Object)available);
        }
        return available;
    }

    protected void waitForCondition(Predicate<? super Window> predicate, long maxWaitTime) throws WindowClosedException, InterruptedException, SocketTimeoutException {
        long maxWaitNanos;
        long nanoWaitDuration;
        Objects.requireNonNull(predicate, "No condition");
        ValidateUtils.checkTrue(maxWaitTime > 0L, "Non-positive max. wait time: %d", maxWaitTime);
        for (long remWaitNanos = maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(maxWaitTime); this.isOpen() && remWaitNanos > 0L; remWaitNanos -= nanoWaitDuration) {
            if (predicate.test(this)) {
                return;
            }
            long curWaitMillis = TimeUnit.NANOSECONDS.toMillis(remWaitNanos);
            long nanoWaitStart = System.nanoTime();
            if (curWaitMillis > 0L) {
                this.lock.wait(curWaitMillis);
            } else {
                this.lock.wait(0L, (int)remWaitNanos);
            }
            long nanoWaitEnd = System.nanoTime();
            nanoWaitDuration = nanoWaitEnd - nanoWaitStart;
        }
        if (!this.isOpen()) {
            throw new WindowClosedException(this.toString());
        }
        throw new SocketTimeoutException("waitForCondition(" + this + ") timeout exceeded: " + maxWaitTime);
    }

    protected void updateSize(long size) {
        BufferUtils.validateUint32Value(size, "Invalid updated size: %d", (Object)size);
        this.sizeHolder.set(size);
        this.lock.notifyAll();
    }

    protected void checkInitialized(String location) {
        if (!this.initialized.get()) {
            throw new IllegalStateException(location + " - window not initialized: " + this);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true) && this.log.isDebugEnabled()) {
            this.log.debug("Closing {}", (Object)this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.suffix + "](" + String.valueOf(this.getChannel()) + ")";
    }
}

