/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IndexRange {
    public static final IndexRange EMPTY = new IndexRange(0, 0);
    public final int start;
    public final int end;

    public IndexRange(int start, int end) {
        Preconditions.checkArgument(start >= 0, "start must be >= 0");
        Preconditions.checkArgument(end >= start, "end must be >= start");
        this.start = start;
        this.end = end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean overlapsWith(IndexRange other) {
        Preconditions.checkNotNull(other, "other");
        return this.end > other.start && other.end > this.start;
    }

    public boolean isPrecededBy(IndexRange other) {
        Preconditions.checkNotNull(other, "other");
        return other.end == this.start;
    }

    public boolean isFollowedBy(IndexRange other) {
        Preconditions.checkNotNull(other, "other");
        return this.end == other.start;
    }

    public boolean touches(IndexRange other) {
        Preconditions.checkNotNull(other, "other");
        return other.end == this.start || this.end == other.start;
    }

    public IndexRange mergedWith(IndexRange other) {
        Preconditions.checkNotNull(other, "other");
        return new IndexRange(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexRange)) {
            return false;
        }
        IndexRange that = (IndexRange)obj;
        return this.end == that.end && this.start == that.start;
    }

    public int hashCode() {
        return this.start ^ this.end;
    }

    @Nonnull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("start", this.start).add("end", this.end).toString();
    }
}

