/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.GerritAuthModule;
import com.google.gerrit.httpd.RemoteUserUtil;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;

@Singleton
class ContainerAuthFilter
implements Filter {
    private static final String LFS_AUTH_PREFIX = "Ssh: ";
    private static final Pattern LFS_ENDPOINT = Pattern.compile(GerritAuthModule.NOT_AUTHORIZED_LFS_URL_REGEX);
    private final DynamicItem<WebSession> session;
    private final AccountCache accountCache;
    private final Config config;
    private final String loginHttpHeader;

    @Inject
    ContainerAuthFilter(DynamicItem<WebSession> session, AccountCache accountCache, AuthConfig authConfig, @GerritServerConfig Config config) {
        this.session = session;
        this.accountCache = accountCache;
        this.config = config;
        this.loginHttpHeader = MoreObjects.firstNonNull(Strings.emptyToNull(authConfig.getLoginHttpHeader()), "Authorization");
    }

    @Override
    public void init(FilterConfig config) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        if (this.verify(req, rsp)) {
            chain.doFilter(req, response);
        }
    }

    private boolean verify(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        AccountState who;
        String username = RemoteUserUtil.getRemoteUser(req, this.loginHttpHeader);
        if (username == null) {
            if (ContainerAuthFilter.isLfsOverSshRequest(req)) {
                return true;
            }
            rsp.sendError(403);
            return false;
        }
        if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
            username = username.toLowerCase(Locale.US);
        }
        if ((who = this.accountCache.getByUsername(username)) == null || !who.getAccount().isActive()) {
            rsp.sendError(401);
            return false;
        }
        WebSession ws = this.session.get();
        ws.setUserAccountId(who.getAccount().getId());
        ws.setAccessPathOk(AccessPath.GIT, true);
        ws.setAccessPathOk(AccessPath.REST_API, true);
        return true;
    }

    private static boolean isLfsOverSshRequest(HttpServletRequest req) {
        String hdr = req.getHeader("Authorization");
        return "application/vnd.git-lfs+json; charset=utf-8".equals(req.getContentType()) && !Strings.isNullOrEmpty(hdr) && hdr.startsWith(LFS_AUTH_PREFIX) && LFS_ENDPOINT.matcher(req.getRequestURI()).matches();
    }
}

