/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.plugins;

import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.httpd.plugins.PluginServletContext;
import com.google.gerrit.httpd.plugins.WrappedFilterConfig;
import com.google.gerrit.httpd.resources.Resource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.plugins.StartPluginListener;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LfsPluginServlet
extends HttpServlet
implements StartPluginListener,
ReloadPluginListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LfsPluginServlet.class);
    private static final String MESSAGE_LFS_NOT_CONFIGURED = "{\"message\":\"No LFS plugin is configured to handle LFS requests.\"}";
    private List<Plugin> pending = new ArrayList<Plugin>();
    private final String pluginName;
    private final FilterChain chain;
    private AtomicReference<GuiceFilter> filter;

    @Inject
    LfsPluginServlet(@GerritServerConfig Config cfg) {
        this.pluginName = cfg.getString("lfs", null, "plugin");
        this.chain = new FilterChain(){

            @Override
            public void doFilter(ServletRequest req, ServletResponse res) throws IOException {
                Resource.NOT_FOUND.send((HttpServletRequest)req, (HttpServletResponse)res);
            }
        };
        this.filter = new AtomicReference();
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.filter.get() == null) {
            this.responseLfsNotConfigured(res);
            return;
        }
        this.filter.get().doFilter(req, res, this.chain);
    }

    @Override
    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        for (Plugin plugin : this.pending) {
            this.install(plugin);
        }
        this.pending = null;
    }

    @Override
    public synchronized void onStartPlugin(Plugin plugin) {
        if (this.pending != null) {
            this.pending.add(plugin);
        } else {
            this.install(plugin);
        }
    }

    @Override
    public void onReloadPlugin(Plugin oldPlugin, Plugin newPlugin) {
        this.install(newPlugin);
    }

    private void responseLfsNotConfigured(HttpServletResponse res) throws IOException {
        CacheHeaders.setNotCacheable(res);
        res.setContentType("application/vnd.git-lfs+json; charset=utf-8");
        res.setStatus(501);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), StandardCharsets.UTF_8));
        w.write(MESSAGE_LFS_NOT_CONFIGURED);
        ((Writer)w).flush();
    }

    private void install(Plugin plugin) {
        if (!plugin.getName().equals(this.pluginName)) {
            return;
        }
        final GuiceFilter guiceFilter = this.load(plugin);
        plugin.add(new RegistrationHandle(){

            @Override
            public void remove() {
                LfsPluginServlet.this.filter.compareAndSet(guiceFilter, null);
            }
        });
        this.filter.set(guiceFilter);
    }

    private GuiceFilter load(Plugin plugin) {
        if (plugin.getHttpInjector() != null) {
            GuiceFilter guiceFilter;
            String name = plugin.getName();
            try {
                guiceFilter = plugin.getHttpInjector().getInstance(GuiceFilter.class);
            }
            catch (RuntimeException e) {
                log.warn("Plugin {} cannot load GuiceFilter", (Object)name, (Object)e);
                return null;
            }
            try {
                ServletContext ctx = PluginServletContext.create(plugin, "/");
                guiceFilter.init(new WrappedFilterConfig(ctx));
            }
            catch (ServletException e) {
                log.warn("Plugin {} failed to initialize HTTP", (Object)name, (Object)e);
                return null;
            }
            plugin.add(new RegistrationHandle(){

                @Override
                public void remove() {
                    guiceFilter.destroy();
                }
            });
            return guiceFilter;
        }
        return null;
    }
}

