/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Description {
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String UNIT = "UNIT";
    public static final String CUMULATIVE = "CUMULATIVE";
    public static final String RATE = "RATE";
    public static final String GAUGE = "GAUGE";
    public static final String CONSTANT = "CONSTANT";
    public static final String FIELD_ORDERING = "FIELD_ORDERING";
    public static final String TRUE_VALUE = "1";
    private final Map<String, String> annotations = Maps.newLinkedHashMapWithExpectedSize(4);
    private static final ImmutableMap<String, TimeUnit> TIME_UNITS = ImmutableMap.of("nanoseconds", TimeUnit.NANOSECONDS, "microseconds", TimeUnit.MICROSECONDS, "milliseconds", TimeUnit.MILLISECONDS, "seconds", TimeUnit.SECONDS);

    public Description(String helpText) {
        this.annotations.put(DESCRIPTION, helpText);
    }

    public Description setUnit(String unitName) {
        this.annotations.put(UNIT, unitName);
        return this;
    }

    public Description setConstant() {
        this.annotations.put(CONSTANT, TRUE_VALUE);
        return this;
    }

    public Description setRate() {
        this.annotations.put(RATE, TRUE_VALUE);
        return this;
    }

    public Description setGauge() {
        this.annotations.put(GAUGE, TRUE_VALUE);
        return this;
    }

    public Description setCumulative() {
        this.annotations.put(CUMULATIVE, TRUE_VALUE);
        return this;
    }

    public Description setFieldOrdering(FieldOrdering ordering) {
        this.annotations.put(FIELD_ORDERING, ordering.name());
        return this;
    }

    public boolean isConstant() {
        return TRUE_VALUE.equals(this.annotations.get(CONSTANT));
    }

    public boolean isRate() {
        return TRUE_VALUE.equals(this.annotations.get(RATE));
    }

    public boolean isGauge() {
        return TRUE_VALUE.equals(this.annotations.get(GAUGE));
    }

    public boolean isCumulative() {
        return TRUE_VALUE.equals(this.annotations.get(CUMULATIVE));
    }

    public FieldOrdering getFieldOrdering() {
        String o = this.annotations.get(FIELD_ORDERING);
        return o != null ? FieldOrdering.valueOf(o) : FieldOrdering.AT_END;
    }

    public TimeUnit getTimeUnit() {
        return Description.getTimeUnit(this.annotations.get(UNIT));
    }

    public static TimeUnit getTimeUnit(String unit) {
        if (Strings.isNullOrEmpty(unit)) {
            throw new IllegalArgumentException("no unit configured");
        }
        TimeUnit u = TIME_UNITS.get(unit);
        if (u == null) {
            throw new IllegalArgumentException(String.format("unit %s not TimeUnit", unit));
        }
        return u;
    }

    public ImmutableMap<String, String> getAnnotations() {
        return ImmutableMap.copyOf(this.annotations);
    }

    public String toString() {
        return this.annotations.toString();
    }

    public static enum FieldOrdering {
        AT_END,
        PREFIX_FIELDS_BASENAME;

    }

    public static class Units {
        public static final String SECONDS = "seconds";
        public static final String MILLISECONDS = "milliseconds";
        public static final String MICROSECONDS = "microseconds";
        public static final String NANOSECONDS = "nanoseconds";
        public static final String BYTES = "bytes";

        private Units() {
        }
    }
}

