/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init.api;

import com.google.gerrit.pgm.init.api.InitFlags;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.SortedSet;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;

@Singleton
public class GitRepositoryManagerOnInit
implements GitRepositoryManager {
    private final InitFlags flags;
    private final SitePaths site;

    @Inject
    GitRepositoryManagerOnInit(InitFlags flags, SitePaths site) {
        this.flags = flags;
        this.site = site;
    }

    @Override
    public Repository openRepository(Project.NameKey name) throws RepositoryNotFoundException, IOException {
        return new FileRepository(this.getPath(name));
    }

    @Override
    public Repository createRepository(Project.NameKey name) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public SortedSet<Project.NameKey> list() {
        throw new UnsupportedOperationException("not implemented");
    }

    private File getPath(Project.NameKey name) {
        Path basePath = this.site.resolve(this.flags.cfg.getString("gerrit", null, "basePath"));
        if (basePath == null) {
            throw new IllegalStateException("gerrit.basePath must be configured");
        }
        return RepositoryCache.FileKey.resolve(basePath.resolve(name.get()).toFile(), FS.DETECTED);
    }
}

