/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.Key;
import java.sql.Timestamp;

public final class Account {
    @Column(id=1)
    protected Id accountId;
    @Column(id=2)
    protected Timestamp registeredOn;
    @Column(id=3, notNull=false)
    protected String fullName;
    @Column(id=4, notNull=false)
    protected String preferredEmail;
    @Column(id=7)
    protected boolean inactive;
    @Column(id=8, notNull=false)
    protected String status;
    protected String userName;
    private GeneralPreferencesInfo generalPreferences;
    private String metaId;

    protected Account() {
    }

    public Account(Id newId, Timestamp registeredOn) {
        this.accountId = newId;
        this.registeredOn = registeredOn;
    }

    public Id getId() {
        return this.accountId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name != null && !name.trim().isEmpty() ? name.trim() : null;
    }

    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public void setPreferredEmail(String addr) {
        this.preferredEmail = addr;
    }

    public String getName(String anonymousCowardName) {
        if (this.fullName != null) {
            return this.fullName;
        }
        if (this.preferredEmail != null) {
            return this.preferredEmail;
        }
        return this.getNameEmail(anonymousCowardName);
    }

    public String getNameEmail(String anonymousCowardName) {
        String name = this.fullName != null ? this.fullName : anonymousCowardName;
        StringBuilder b = new StringBuilder();
        b.append(name);
        if (this.preferredEmail != null) {
            b.append(" <");
            b.append(this.preferredEmail);
            b.append(">");
        } else if (this.accountId != null) {
            b.append(" (");
            b.append(this.accountId.get());
            b.append(")");
        }
        return b.toString();
    }

    public Timestamp getRegisteredOn() {
        return this.registeredOn;
    }

    public GeneralPreferencesInfo getGeneralPreferencesInfo() {
        return this.generalPreferences;
    }

    public void setGeneralPreferences(GeneralPreferencesInfo p) {
        this.generalPreferences = p;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public boolean isActive() {
        return !this.inactive;
    }

    public void setActive(boolean active) {
        this.inactive = !active;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        return o instanceof Account && ((Account)o).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().get();
    }

    public static class Id
    extends IntKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        @Override
        public int get() {
            return this.id;
        }

        @Override
        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String name) {
            if (name == null) {
                return null;
            }
            if (name.startsWith("refs/users/")) {
                return Id.fromRefPart(name.substring("refs/users/".length()));
            }
            if (name.startsWith("refs/draft-comments/")) {
                return Id.parseAfterShardedRefPart(name.substring("refs/draft-comments/".length()));
            }
            if (name.startsWith("refs/starred-changes/")) {
                return Id.parseAfterShardedRefPart(name.substring("refs/starred-changes/".length()));
            }
            return null;
        }

        public static Id fromRefPart(String name) {
            Integer id = RefNames.parseShardedRefPart(name);
            return id != null ? new Id(id) : null;
        }

        public static Id parseAfterShardedRefPart(String name) {
            Integer id = RefNames.parseAfterShardedRefPart(name);
            return id != null ? new Id(id) : null;
        }

        public static Id fromRefSuffix(String name) {
            Integer id = RefNames.parseRefSuffix(name);
            return id != null ? new Id(id) : null;
        }
    }
}

