/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PatchSet {
    @Column(id=1, name="--NONE--")
    protected Id id;
    @Column(id=2, notNull=false)
    protected RevId revision;
    @Column(id=3, name="uploader_account_id")
    protected Account.Id uploader;
    @Column(id=4)
    protected Timestamp createdOn;
    @Column(id=6, notNull=false, length=0x7FFFFFFF)
    protected String groups;
    @Column(id=8, notNull=false, length=0x7FFFFFFF)
    protected String pushCertificate;
    @Column(id=9, notNull=false, length=0x7FFFFFFF)
    protected String description;

    public static boolean isChangeRef(String name) {
        return Id.fromRef(name) != null;
    }

    @Deprecated
    public static boolean isRef(String name) {
        return PatchSet.isChangeRef(name);
    }

    static String joinGroups(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("groups may not be null");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String g : groups) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(g);
        }
        return sb.toString();
    }

    public static List<String> splitGroups(String joinedGroups) {
        if (joinedGroups == null) {
            throw new IllegalArgumentException("groups may not be null");
        }
        ArrayList<String> groups = new ArrayList<String>();
        int i = 0;
        while (true) {
            int idx;
            if ((idx = joinedGroups.indexOf(44, i)) < 0) break;
            groups.add(joinedGroups.substring(i, idx));
            i = idx + 1;
        }
        groups.add(joinedGroups.substring(i, joinedGroups.length()));
        return groups;
    }

    protected PatchSet() {
    }

    public PatchSet(Id k) {
        this.id = k;
    }

    public PatchSet(PatchSet src) {
        this.id = src.id;
        this.revision = src.revision;
        this.uploader = src.uploader;
        this.createdOn = src.createdOn;
        this.groups = src.groups;
        this.pushCertificate = src.pushCertificate;
        this.description = src.description;
    }

    public Id getId() {
        return this.id;
    }

    public int getPatchSetId() {
        return this.id.get();
    }

    public RevId getRevision() {
        return this.revision;
    }

    public void setRevision(RevId i) {
        this.revision = i;
    }

    public Account.Id getUploader() {
        return this.uploader;
    }

    public void setUploader(Account.Id who) {
        this.uploader = who;
    }

    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Timestamp ts) {
        this.createdOn = ts;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        return PatchSet.splitGroups(this.groups);
    }

    public void setGroups(List<String> groups) {
        if (groups == null) {
            groups = Collections.emptyList();
        }
        this.groups = PatchSet.joinGroups(groups);
    }

    public String getRefName() {
        return this.id.toRefName();
    }

    public String getPushCertificate() {
        return this.pushCertificate;
    }

    public void setPushCertificate(String cert) {
        this.pushCertificate = cert;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "[PatchSet " + this.getId().toString() + "]";
    }

    public static class Id
    extends IntKey<Change.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        public Change.Id changeId;
        @Column(id=2)
        public int patchSetId;

        public Id() {
            this.changeId = new Change.Id();
        }

        public Id(Change.Id change, int id) {
            this.changeId = change;
            this.patchSetId = id;
        }

        @Override
        public Change.Id getParentKey() {
            return this.changeId;
        }

        @Override
        public int get() {
            return this.patchSetId;
        }

        @Override
        protected void set(int newValue) {
            this.patchSetId = newValue;
        }

        public String toRefName() {
            return this.changeId.refPrefixBuilder().append(this.patchSetId).toString();
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String ref) {
            int cs = Change.Id.startIndex(ref);
            if (cs < 0) {
                return null;
            }
            int ce = Change.Id.nextNonDigit(ref, cs);
            int patchSetId = Id.fromRef(ref, ce);
            if (patchSetId < 0) {
                return null;
            }
            int changeId = Integer.parseInt(ref.substring(cs, ce));
            return new Id(new Change.Id(changeId), patchSetId);
        }

        static int fromRef(String ref, int changeIdEnd) {
            int ps = changeIdEnd + 1;
            if (ps >= ref.length() || ref.charAt(ps) == '0') {
                return -1;
            }
            for (int i = ps; i < ref.length(); ++i) {
                if (ref.charAt(i) >= '0' && ref.charAt(i) <= '9') continue;
                return -1;
            }
            return Integer.parseInt(ref.substring(ps));
        }

        public String getId() {
            return Id.toId(this.patchSetId);
        }

        public static String toId(int number) {
            return number == 0 ? "edit" : String.valueOf(number);
        }
    }
}

