/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer2;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.RepoSequence;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.eclipse.jgit.lib.Config;

@Singleton
public class Sequences {
    public static final String NAME_ACCOUNTS = "accounts";
    public static final String NAME_CHANGES = "changes";
    private final Provider<ReviewDb> db;
    private final NotesMigration migration;
    private final RepoSequence accountSeq;
    private final RepoSequence changeSeq;
    private final Timer2<SequenceType, Boolean> nextIdLatency;

    public static int getChangeSequenceGap(Config cfg) {
        return cfg.getInt("noteDb", NAME_CHANGES, "initialSequenceGap", 1000);
    }

    @Inject
    Sequences(@GerritServerConfig Config cfg, Provider<ReviewDb> db, NotesMigration migration, GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated, AllProjectsName allProjects, AllUsersName allUsers, MetricMaker metrics) {
        this.db = db;
        this.migration = migration;
        int accountBatchSize = cfg.getInt("noteDb", NAME_ACCOUNTS, "sequenceBatchSize", 1);
        this.accountSeq = new RepoSequence(repoManager, gitRefUpdated, allUsers, NAME_ACCOUNTS, () -> 1000000, accountBatchSize);
        int gap = Sequences.getChangeSequenceGap(cfg);
        RepoSequence.Seed changeSeed = () -> ((ReviewDb)db.get()).nextChangeId() + gap;
        int changeBatchSize = cfg.getInt("noteDb", NAME_CHANGES, "sequenceBatchSize", 20);
        this.changeSeq = new RepoSequence(repoManager, gitRefUpdated, allProjects, NAME_CHANGES, changeSeed, changeBatchSize);
        this.nextIdLatency = metrics.newTimer("sequence/next_id_latency", new Description("Latency of requesting IDs from repo sequences").setCumulative().setUnit("milliseconds"), Field.ofEnum(SequenceType.class, "sequence"), Field.ofBoolean("multiple"));
    }

    public int nextAccountId() throws OrmException {
        try (Timer2.Context timer = this.nextIdLatency.start(SequenceType.ACCOUNTS, false);){
            int n = this.accountSeq.next();
            return n;
        }
    }

    public int nextChangeId() throws OrmException {
        if (!this.migration.readChangeSequence()) {
            return Sequences.nextChangeId(this.db.get());
        }
        try (Timer2.Context timer = this.nextIdLatency.start(SequenceType.CHANGES, false);){
            int n = this.changeSeq.next();
            return n;
        }
    }

    public ImmutableList<Integer> nextChangeIds(int count) throws OrmException {
        if (this.migration.readChangeSequence()) {
            try (Timer2.Context timer = this.nextIdLatency.start(SequenceType.CHANGES, count > 1);){
                ImmutableList<Integer> immutableList = this.changeSeq.next(count);
                return immutableList;
            }
        }
        if (count == 0) {
            return ImmutableList.of();
        }
        Preconditions.checkArgument(count > 0, "count is negative: %s", count);
        ArrayList<Integer> ids = new ArrayList<Integer>(count);
        ReviewDb db = this.db.get();
        for (int i = 0; i < count; ++i) {
            ids.add(Sequences.nextChangeId(db));
        }
        return ImmutableList.copyOf(ids);
    }

    @VisibleForTesting
    public RepoSequence getChangeIdRepoSequence() {
        return this.changeSeq;
    }

    private static int nextChangeId(ReviewDb db) throws OrmException {
        return db.nextChangeId();
    }

    private static enum SequenceType {
        ACCOUNTS,
        CHANGES;

    }
}

