/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AccountsUpdate;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class PutName
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final Realm realm;
    private final PermissionBackend permissionBackend;
    private final AccountsUpdate.Server accountsUpdate;

    @Inject
    PutName(Provider<CurrentUser> self, Realm realm, PermissionBackend permissionBackend, AccountsUpdate.Server accountsUpdate) {
        this.self = self;
        this.realm = realm;
        this.permissionBackend = permissionBackend;
        this.accountsUpdate = accountsUpdate;
    }

    public Response<String> apply(AccountResource rsrc, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException, IOException, PermissionBackendException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.MODIFY_ACCOUNT);
        }
        return this.apply(rsrc.getUser(), input);
    }

    public Response<String> apply(IdentifiedUser user, Input input) throws MethodNotAllowedException, ResourceNotFoundException, IOException, ConfigInvalidException {
        if (input == null) {
            input = new Input();
        }
        if (!this.realm.allowsEdit(AccountFieldName.FULL_NAME)) {
            throw new MethodNotAllowedException("realm does not allow editing name");
        }
        String newName = input.name;
        Account account = this.accountsUpdate.create().update(user.getAccountId(), a -> a.setFullName(newName));
        if (account == null) {
            throw new ResourceNotFoundException("account not found");
        }
        return Strings.isNullOrEmpty(account.getFullName()) ? Response.none() : Response.ok(account.getFullName());
    }

    public static class Input {
        @DefaultInput
        public String name;
    }
}

