/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.oauth;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.auth.oauth.OAuthLoginProvider;
import com.google.gerrit.extensions.auth.oauth.OAuthUserInfo;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AbstractRealm;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.Config;

@Singleton
public class OAuthRealm
extends AbstractRealm {
    private final DynamicMap<OAuthLoginProvider> loginProviders;
    private final Set<AccountFieldName> editableAccountFields;

    @Inject
    OAuthRealm(DynamicMap<OAuthLoginProvider> loginProviders, @GerritServerConfig Config config) {
        this.loginProviders = loginProviders;
        this.editableAccountFields = new HashSet<AccountFieldName>();
        this.editableAccountFields.add(AccountFieldName.USER_NAME);
        if (config.getBoolean("oauth", null, "allowEditFullName", false)) {
            this.editableAccountFields.add(AccountFieldName.FULL_NAME);
        }
        if (config.getBoolean("oauth", null, "allowRegisterNewEmail", false)) {
            this.editableAccountFields.add(AccountFieldName.REGISTER_NEW_EMAIL);
        }
    }

    @Override
    public boolean allowsEdit(AccountFieldName field) {
        return this.editableAccountFields.contains((Object)field);
    }

    @Override
    public AuthRequest authenticate(AuthRequest who) throws AccountException {
        OAuthUserInfo userInfo;
        if (Strings.isNullOrEmpty(who.getPassword())) {
            return who;
        }
        if (Strings.isNullOrEmpty(who.getAuthPlugin()) || Strings.isNullOrEmpty(who.getAuthProvider())) {
            throw new AccountException("Cannot authenticate");
        }
        OAuthLoginProvider loginProvider = this.loginProviders.get(who.getAuthPlugin(), who.getAuthProvider());
        if (loginProvider == null) {
            throw new AccountException("Cannot authenticate");
        }
        try {
            userInfo = loginProvider.login(who.getUserName(), who.getPassword());
        }
        catch (IOException e) {
            throw new AccountException("Cannot authenticate", e);
        }
        if (userInfo == null) {
            throw new AccountException("Cannot authenticate");
        }
        if (!(Strings.isNullOrEmpty(userInfo.getEmailAddress()) || !Strings.isNullOrEmpty(who.getUserName()) && this.allowsEdit(AccountFieldName.REGISTER_NEW_EMAIL))) {
            who.setEmailAddress(userInfo.getEmailAddress());
        }
        if (!(Strings.isNullOrEmpty(userInfo.getDisplayName()) || !Strings.isNullOrEmpty(who.getDisplayName()) && this.allowsEdit(AccountFieldName.FULL_NAME))) {
            who.setDisplayName(userInfo.getDisplayName());
        }
        return who;
    }

    @Override
    public void onCreateAccount(AuthRequest who, Account account) {
    }

    @Override
    public Account.Id lookup(String accountName) {
        return null;
    }

    @Override
    public boolean accountBelongsToRealm(Collection<ExternalId> externalIds) {
        for (ExternalId id : externalIds) {
            if (!id.toString().contains("external")) continue;
            return true;
        }
        return false;
    }
}

