/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.change.AbandonUtil;
import com.google.gerrit.server.config.ChangeCleanupConfig;
import com.google.gerrit.server.config.ScheduleConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.ManualRequestContext;
import com.google.gerrit.server.util.OneOffRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeCleanupRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ChangeCleanupRunner.class);
    private final OneOffRequestContext oneOffRequestContext;
    private final AbandonUtil abandonUtil;
    private final RetryHelper retryHelper;

    @Inject
    ChangeCleanupRunner(OneOffRequestContext oneOffRequestContext, AbandonUtil abandonUtil, RetryHelper retryHelper) {
        this.oneOffRequestContext = oneOffRequestContext;
        this.abandonUtil = abandonUtil;
        this.retryHelper = retryHelper;
    }

    @Override
    public void run() {
        log.info("Running change cleanups.");
        try (ManualRequestContext ctx = this.oneOffRequestContext.open();){
            this.retryHelper.execute(updateFactory -> {
                this.abandonUtil.abandonInactiveOpenChanges(updateFactory);
                return null;
            });
        }
        catch (RestApiException | UpdateException | OrmException e) {
            log.error("Failed to cleanup changes.", e);
        }
    }

    public String toString() {
        return "change cleanup runner";
    }

    static class Lifecycle
    implements LifecycleListener {
        private final WorkQueue queue;
        private final ChangeCleanupRunner runner;
        private final ChangeCleanupConfig cfg;

        @Inject
        Lifecycle(WorkQueue queue, ChangeCleanupRunner runner, ChangeCleanupConfig cfg) {
            this.queue = queue;
            this.runner = runner;
            this.cfg = cfg;
        }

        @Override
        public void start() {
            ScheduleConfig scheduleConfig = this.cfg.getScheduleConfig();
            long interval = scheduleConfig.getInterval();
            long delay = scheduleConfig.getInitialDelay();
            if (delay == -1L && interval == -1L) {
                log.info("Ignoring missing changeCleanup schedule configuration");
            } else if (delay < 0L || interval <= 0L) {
                log.warn("Ignoring invalid changeCleanup schedule configuration: {}", (Object)scheduleConfig);
            } else {
                ScheduledFuture<?> scheduledFuture = this.queue.getDefaultQueue().scheduleAtFixedRate(this.runner, delay, interval, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public void stop() {
        }
    }

    public static class Module
    extends LifecycleModule {
        @Override
        protected void configure() {
            this.listener().to(Lifecycle.class);
        }
    }
}

