/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetCommit
implements RestReadView<RevisionResource> {
    private final GitRepositoryManager repoManager;
    private final ChangeJson.Factory json;
    private boolean addLinks;

    @Inject
    GetCommit(GitRepositoryManager repoManager, ChangeJson.Factory json) {
        this.repoManager = repoManager;
        this.json = json;
    }

    @Option(name="--links", usage="Include weblinks")
    public GetCommit setAddLinks(boolean addLinks) {
        this.addLinks = addLinks;
        return this;
    }

    public Response<CommitInfo> apply(RevisionResource rsrc) throws IOException {
        Project.NameKey p = rsrc.getChange().getProject();
        Throwable throwable = null;
        try (Repository repo = this.repoManager.openRepository(p);){
            Response<CommitInfo> response;
            RevWalk rw = new RevWalk(repo);
            Throwable throwable2 = null;
            try {
                String rev = rsrc.getPatchSet().getRevision().get();
                RevCommit commit = rw.parseCommit(ObjectId.fromString(rev));
                rw.parseBody(commit);
                CommitInfo info = this.json.noOptions().toCommit(rsrc.getProject(), rw, commit, this.addLinks, true);
                Response<CommitInfo> r = Response.ok(info);
                if (rsrc.isCacheable()) {
                    r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
                }
                response = r;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        GetCommit.$closeResource(throwable2, rw);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            GetCommit.$closeResource(throwable2, rw);
            return response;
        }
    }
}

