/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HashtagsUtil {
    private static final CharMatcher LEADER = CharMatcher.whitespace().or(CharMatcher.is('#'));
    private static final String PATTERN = "(?:\\s|\\A)#[\\p{L}[0-9]-_]+";

    public static String cleanupHashtag(String hashtag) {
        hashtag = LEADER.trimLeadingFrom(hashtag);
        hashtag = CharMatcher.whitespace().trimTrailingFrom(hashtag);
        return hashtag;
    }

    public static Set<String> extractTags(String input) {
        HashSet<String> result = new HashSet<String>();
        if (!Strings.isNullOrEmpty(input)) {
            Matcher matcher = Pattern.compile(PATTERN).matcher(input);
            while (matcher.find()) {
                result.add(HashtagsUtil.cleanupHashtag(matcher.group()));
            }
        }
        return result;
    }

    static Set<String> extractTags(Set<String> input) throws InvalidHashtagException {
        if (input == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String hashtag : input) {
            if (hashtag.contains(",")) {
                throw InvalidHashtagException.hashtagsMayNotContainCommas();
            }
            if ((hashtag = HashtagsUtil.cleanupHashtag(hashtag)).isEmpty()) continue;
            result.add(hashtag);
        }
        return result;
    }

    private HashtagsUtil() {
    }

    public static class InvalidHashtagException
    extends Exception {
        private static final long serialVersionUID = 1L;

        static InvalidHashtagException hashtagsMayNotContainCommas() {
            return new InvalidHashtagException("hashtags may not contain commas");
        }

        InvalidHashtagException(String message) {
            super(message);
        }
    }
}

