/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class Index
extends RetryingRestModifyView<ChangeResource, Input, Response<?>> {
    private final Provider<ReviewDb> db;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final ChangeIndexer indexer;

    @Inject
    Index(Provider<ReviewDb> db, RetryHelper retryHelper, PermissionBackend permissionBackend, Provider<CurrentUser> user, ChangeIndexer indexer) {
        super(retryHelper);
        this.db = db;
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.indexer = indexer;
    }

    @Override
    protected Response<?> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, Input input) throws IOException, AuthException, OrmException, PermissionBackendException {
        this.permissionBackend.user(this.user).check(GlobalPermission.MAINTAIN_SERVER);
        this.indexer.index(this.db.get(), rsrc.getChange());
        return Response.none();
    }

    public static class Input {
    }
}

