/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.ListRevisionDrafts;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class ListRevisionComments
extends ListRevisionDrafts {
    @Inject
    ListRevisionComments(Provider<ReviewDb> db, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        super(db, commentJson, commentsUtil);
    }

    @Override
    protected boolean includeAuthorInfo() {
        return true;
    }

    @Override
    protected Iterable<Comment> listComments(RevisionResource rsrc) throws OrmException {
        ChangeNotes notes = rsrc.getNotes();
        return this.commentsUtil.publishedByPatchSet((ReviewDb)this.db.get(), notes, rsrc.getPatchSet().getId());
    }
}

