/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.NotifyInfo;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class NotifyUtil {
    private final AccountResolver accountResolver;

    @Inject
    NotifyUtil(AccountResolver accountResolver) {
        this.accountResolver = accountResolver;
    }

    public static boolean shouldNotify(NotifyHandling notify, @Nullable Map<RecipientType, NotifyInfo> notifyDetails) {
        if (!NotifyUtil.isNullOrEmpty(notifyDetails)) {
            return true;
        }
        return notify.compareTo(NotifyHandling.NONE) > 0;
    }

    private static boolean isNullOrEmpty(@Nullable Map<RecipientType, NotifyInfo> notifyDetails) {
        if (notifyDetails == null || notifyDetails.isEmpty()) {
            return true;
        }
        for (NotifyInfo notifyInfo : notifyDetails.values()) {
            if (NotifyUtil.isEmpty(notifyInfo)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(NotifyInfo notifyInfo) {
        return notifyInfo.accounts == null || notifyInfo.accounts.isEmpty();
    }

    public ListMultimap<RecipientType, Account.Id> resolveAccounts(@Nullable Map<RecipientType, NotifyInfo> notifyDetails) throws OrmException, BadRequestException, IOException, ConfigInvalidException {
        if (NotifyUtil.isNullOrEmpty(notifyDetails)) {
            return ImmutableListMultimap.of();
        }
        Multimap<RecipientType, Account.Id> m = null;
        for (Map.Entry<RecipientType, NotifyInfo> e : notifyDetails.entrySet()) {
            List<String> accounts = e.getValue().accounts;
            if (accounts == null) continue;
            if (m == null) {
                m = MultimapBuilder.hashKeys().arrayListValues().build();
            }
            m.putAll(e.getKey(), this.find(accounts));
        }
        return m != null ? m : ImmutableListMultimap.of();
    }

    private List<Account.Id> find(List<String> nameOrEmails) throws OrmException, BadRequestException, IOException, ConfigInvalidException {
        ArrayList<String> missing = new ArrayList<String>(nameOrEmails.size());
        ArrayList<Account.Id> r = new ArrayList<Account.Id>(nameOrEmails.size());
        for (String nameOrEmail : nameOrEmails) {
            Account a = this.accountResolver.find(nameOrEmail);
            if (a != null) {
                r.add(a.getId());
                continue;
            }
            missing.add(nameOrEmail);
        }
        if (!missing.isEmpty()) {
            throw new BadRequestException("The following accounts that should be notified could not be resolved: " + missing.stream().distinct().sorted().collect(Collectors.joining(", ")));
        }
        return r;
    }
}

