/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.change.AutoValue_PostReviewersOp_Result;
import com.google.gerrit.server.extensions.events.ReviewerAdded;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.AddReviewerSender;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostReviewersOp
implements BatchUpdateOp {
    private static final Logger log = LoggerFactory.getLogger(PostReviewersOp.class);
    private final ApprovalsUtil approvalsUtil;
    private final PatchSetUtil psUtil;
    private final ReviewerAdded reviewerAdded;
    private final AccountCache accountCache;
    private final ProjectCache projectCache;
    private final AddReviewerSender.Factory addReviewerSenderFactory;
    private final NotesMigration migration;
    private final Provider<IdentifiedUser> user;
    private final Provider<ReviewDb> dbProvider;
    private final Set<Account.Id> reviewers;
    private final Collection<Address> reviewersByEmail;
    private final ReviewerState state;
    private final NotifyHandling notify;
    private final ListMultimap<RecipientType, Account.Id> accountsToNotify;
    private List<PatchSetApproval> addedReviewers = new ArrayList<PatchSetApproval>();
    private Collection<Account.Id> addedCCs = new ArrayList<Account.Id>();
    private Collection<Address> addedCCsByEmail = new ArrayList<Address>();
    private Change change;
    private PatchSet patchSet;
    private Result opResult;

    @Inject
    PostReviewersOp(ApprovalsUtil approvalsUtil, PatchSetUtil psUtil, ReviewerAdded reviewerAdded, AccountCache accountCache, ProjectCache projectCache, AddReviewerSender.Factory addReviewerSenderFactory, NotesMigration migration, Provider<IdentifiedUser> user, Provider<ReviewDb> dbProvider, @Assisted Set<Account.Id> reviewers, @Assisted Collection<Address> reviewersByEmail, @Assisted ReviewerState state, @Assisted @Nullable NotifyHandling notify, @Assisted ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.approvalsUtil = approvalsUtil;
        this.psUtil = psUtil;
        this.reviewerAdded = reviewerAdded;
        this.accountCache = accountCache;
        this.projectCache = projectCache;
        this.addReviewerSenderFactory = addReviewerSenderFactory;
        this.migration = migration;
        this.user = user;
        this.dbProvider = dbProvider;
        this.reviewers = reviewers;
        this.reviewersByEmail = reviewersByEmail;
        this.state = state;
        this.notify = notify;
        this.accountsToNotify = accountsToNotify;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException {
        this.change = ctx.getChange();
        if (!this.reviewers.isEmpty()) {
            if (this.migration.readChanges() && this.state == ReviewerState.CC) {
                this.addedCCs = this.approvalsUtil.addCcs(ctx.getNotes(), ctx.getUpdate(this.change.currentPatchSetId()), this.reviewers);
                if (this.addedCCs.isEmpty()) {
                    return false;
                }
            } else {
                this.addedReviewers = this.approvalsUtil.addReviewers(ctx.getDb(), ctx.getNotes(), ctx.getUpdate(ctx.getChange().currentPatchSetId()), this.projectCache.checkedGet(this.change.getProject()).getLabelTypes(this.change.getDest(), ctx.getUser()), this.change, this.reviewers);
                if (this.addedReviewers.isEmpty()) {
                    return false;
                }
            }
        }
        for (Address a : this.reviewersByEmail) {
            ctx.getUpdate(ctx.getChange().currentPatchSetId()).putReviewerByEmail(a, ReviewerStateInternal.fromReviewerState(this.state));
        }
        this.patchSet = this.psUtil.current(this.dbProvider.get(), ctx.getNotes());
        return true;
    }

    @Override
    public void postUpdate(Context ctx) throws Exception {
        this.opResult = Result.builder().setAddedReviewers(ImmutableList.copyOf(this.addedReviewers)).setAddedCCs(ImmutableList.copyOf(this.addedCCs)).build();
        this.emailReviewers(this.change, Lists.transform(this.addedReviewers, r -> r.getAccountId()), this.addedCCs == null ? ImmutableList.of() : this.addedCCs, this.reviewersByEmail, this.addedCCsByEmail, this.notify, this.accountsToNotify);
        if (!this.addedReviewers.isEmpty()) {
            List<Account> reviewers = this.addedReviewers.stream().map(r -> this.accountCache.get(r.getAccountId()).getAccount()).collect(Collectors.toList());
            this.reviewerAdded.fire(this.change, this.patchSet, reviewers, ctx.getAccount(), ctx.getWhen());
        }
    }

    public void emailReviewers(Change change, Collection<Account.Id> added, Collection<Account.Id> copied, Collection<Address> addedByEmail, Collection<Address> copiedByEmail, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        if (added.isEmpty() && copied.isEmpty() && addedByEmail.isEmpty() && copiedByEmail.isEmpty()) {
            return;
        }
        ArrayList<Account.Id> toMail = Lists.newArrayListWithCapacity(added.size());
        Account.Id userId = this.user.get().getAccountId();
        for (Account.Id id : added) {
            if (id.equals(userId)) continue;
            toMail.add(id);
        }
        ArrayList<Account.Id> toCopy = Lists.newArrayListWithCapacity(copied.size());
        for (Account.Id id : copied) {
            if (id.equals(userId)) continue;
            toCopy.add(id);
        }
        if (toMail.isEmpty() && toCopy.isEmpty() && addedByEmail.isEmpty() && copiedByEmail.isEmpty()) {
            return;
        }
        try {
            AddReviewerSender addReviewerSender = this.addReviewerSenderFactory.create(change.getProject(), change.getId());
            NotifyHandling defaultNotifyHandling = change.isWorkInProgress() ? NotifyHandling.NONE : NotifyHandling.ALL;
            addReviewerSender.setNotify(MoreObjects.firstNonNull(notify, defaultNotifyHandling));
            addReviewerSender.setAccountsToNotify(accountsToNotify);
            addReviewerSender.setFrom(userId);
            addReviewerSender.addReviewers(toMail);
            addReviewerSender.addReviewersByEmail(addedByEmail);
            addReviewerSender.addExtraCC(toCopy);
            addReviewerSender.addExtraCCByEmail(copiedByEmail);
            addReviewerSender.send();
        }
        catch (Exception exception) {
            log.error("Cannot send email to new reviewers of change " + change.getId(), exception);
        }
    }

    public Result getResult() {
        Preconditions.checkState(this.opResult != null, "Batch update wasn't executed yet");
        return this.opResult;
    }

    @AutoValue
    public static abstract class Result {
        public abstract ImmutableList<PatchSetApproval> addedReviewers();

        public abstract ImmutableList<Account.Id> addedCCs();

        static Builder builder() {
            return new AutoValue_PostReviewersOp_Result.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setAddedReviewers(ImmutableList<PatchSetApproval> var1);

            abstract Builder setAddedCCs(ImmutableList<Account.Id> var1);

            abstract Result build();
        }
    }

    public static interface Factory {
        public PostReviewersOp create(Set<Account.Id> var1, Collection<Address> var2, ReviewerState var3, @Nullable NotifyHandling var4, ListMultimap<RecipientType, Account.Id> var5);
    }
}

