/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.AutoValue_RelatedChangesSorter_PatchSetData;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
class RelatedChangesSorter {
    private final GitRepositoryManager repoManager;
    private final PermissionBackend permissionBackend;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    RelatedChangesSorter(GitRepositoryManager repoManager, PermissionBackend permissionBackend, Provider<ReviewDb> dbProvider) {
        this.repoManager = repoManager;
        this.permissionBackend = permissionBackend;
        this.dbProvider = dbProvider;
    }

    public List<PatchSetData> sort(List<ChangeData> in, PatchSet startPs, CurrentUser user) throws OrmException, IOException, PermissionBackendException {
        Preconditions.checkArgument(!in.isEmpty(), "Input may not be empty");
        Map<String, PatchSetData> byId = this.collectById(in);
        PatchSetData start = byId.get(startPs.getRevision().get());
        Preconditions.checkArgument(start != null, "%s not found in %s", (Object)startPs, in);
        PermissionBackend.WithUser perm = (PermissionBackend.WithUser)this.permissionBackend.user(user).database(this.dbProvider);
        Multimap parents = MultimapBuilder.hashKeys(in.size()).arrayListValues(3).build();
        Multimap children = MultimapBuilder.hashKeys(in.size()).arrayListValues(3).build();
        ArrayList<PatchSetData> otherPatchSetsOfStart = new ArrayList<PatchSetData>();
        for (ChangeData cd : in) {
            for (PatchSet ps : cd.patchSets()) {
                PatchSetData thisPsd = Preconditions.checkNotNull(byId.get(ps.getRevision().get()));
                if (cd.getId().equals(start.id()) && !ps.getId().equals(start.psId())) {
                    otherPatchSetsOfStart.add(thisPsd);
                }
                for (RevCommit p : thisPsd.commit().getParents()) {
                    PatchSetData parentPsd = byId.get(p.name());
                    if (parentPsd == null) continue;
                    parents.put(thisPsd, parentPsd);
                    children.put(parentPsd, thisPsd);
                }
            }
        }
        Collection<PatchSetData> ancestors = RelatedChangesSorter.walkAncestors(perm, (ListMultimap<PatchSetData, PatchSetData>)parents, start);
        List<PatchSetData> descendants = RelatedChangesSorter.walkDescendants(perm, (ListMultimap<PatchSetData, PatchSetData>)children, start, otherPatchSetsOfStart, ancestors);
        ArrayList<PatchSetData> result = new ArrayList<PatchSetData>(ancestors.size() + descendants.size() - 1);
        result.addAll(Lists.reverse(descendants));
        result.addAll(ancestors);
        return result;
    }

    private Map<String, PatchSetData> collectById(List<ChangeData> in) throws OrmException, IOException {
        Project.NameKey project = in.get(0).change().getProject();
        HashMap<String, PatchSetData> result = Maps.newHashMapWithExpectedSize(in.size() * 3);
        try (Repository repo = this.repoManager.openRepository(project);
             RevWalk rw = new RevWalk(repo);){
            rw.setRetainBody(true);
            for (ChangeData cd : in) {
                Preconditions.checkArgument(cd.change().getProject().equals(project), "Expected change %s in project %s, found %s", (Object)cd.getId(), (Object)project, (Object)cd.change().getProject());
                for (PatchSet ps : cd.patchSets()) {
                    String id = ps.getRevision().get();
                    RevCommit c = rw.parseCommit(ObjectId.fromString(id));
                    PatchSetData psd = PatchSetData.create(cd, ps, c);
                    result.put(id, psd);
                }
            }
        }
        return result;
    }

    private static Collection<PatchSetData> walkAncestors(PermissionBackend.WithUser perm, ListMultimap<PatchSetData, PatchSetData> parents, PatchSetData start) throws PermissionBackendException {
        LinkedHashSet<PatchSetData> result = new LinkedHashSet<PatchSetData>();
        ArrayDeque<PatchSetData> pending = new ArrayDeque<PatchSetData>();
        pending.add(start);
        while (!pending.isEmpty()) {
            PatchSetData psd = (PatchSetData)pending.remove();
            if (result.contains(psd) || !RelatedChangesSorter.isVisible(psd, perm)) continue;
            result.add(psd);
            pending.addAll(Lists.reverse(parents.get((Object)psd)));
        }
        return result;
    }

    private static List<PatchSetData> walkDescendants(PermissionBackend.WithUser perm, ListMultimap<PatchSetData, PatchSetData> children, PatchSetData start, List<PatchSetData> otherPatchSetsOfStart, Iterable<PatchSetData> ancestors) throws PermissionBackendException {
        HashSet<Change.Id> alreadyEmittedChanges = new HashSet<Change.Id>();
        RelatedChangesSorter.addAllChangeIds(alreadyEmittedChanges, ancestors);
        List<PatchSetData> result = RelatedChangesSorter.walkDescendentsImpl(perm, alreadyEmittedChanges, children, ImmutableList.of(start));
        RelatedChangesSorter.addAllChangeIds(alreadyEmittedChanges, result);
        result.addAll(RelatedChangesSorter.walkDescendentsImpl(perm, alreadyEmittedChanges, children, otherPatchSetsOfStart));
        return result;
    }

    private static void addAllChangeIds(Collection<Change.Id> changeIds, Iterable<PatchSetData> psds) {
        for (PatchSetData psd : psds) {
            changeIds.add(psd.id());
        }
    }

    private static List<PatchSetData> walkDescendentsImpl(PermissionBackend.WithUser perm, Set<Change.Id> alreadyEmittedChanges, ListMultimap<PatchSetData, PatchSetData> children, List<PatchSetData> start) throws PermissionBackendException {
        if (start.isEmpty()) {
            return ImmutableList.of();
        }
        HashMap<Change.Id, PatchSet.Id> maxPatchSetIds = new HashMap<Change.Id, PatchSet.Id>();
        HashSet<PatchSetData> seen = new HashSet<PatchSetData>();
        ArrayList<PatchSetData> allPatchSets = new ArrayList<PatchSetData>();
        ArrayDeque<PatchSetData> pending = new ArrayDeque<PatchSetData>();
        pending.addAll(start);
        while (!pending.isEmpty()) {
            PatchSetData psd = (PatchSetData)pending.remove();
            if (seen.contains(psd) || !RelatedChangesSorter.isVisible(psd, perm)) continue;
            seen.add(psd);
            if (!alreadyEmittedChanges.contains(psd.id())) {
                PatchSet.Id oldMax = (PatchSet.Id)maxPatchSetIds.get(psd.id());
                if (oldMax == null || psd.psId().get() > oldMax.get()) {
                    maxPatchSetIds.put(psd.id(), psd.psId());
                }
                allPatchSets.add(psd);
            }
            for (PatchSetData child : children.get((Object)psd)) {
                pending.addFirst(child);
            }
        }
        ArrayList<PatchSetData> result = new ArrayList<PatchSetData>(allPatchSets.size());
        for (PatchSetData psd : allPatchSets) {
            if (!Preconditions.checkNotNull((PatchSet.Id)maxPatchSetIds.get(psd.id())).equals(psd.psId())) continue;
            result.add(psd);
        }
        return result;
    }

    private static boolean isVisible(PatchSetData psd, PermissionBackend.WithUser perm) throws PermissionBackendException {
        try {
            perm.change(psd.data()).check(ChangePermission.READ);
            return true;
        }
        catch (AuthException e) {
            return false;
        }
    }

    @AutoValue
    static abstract class PatchSetData {
        PatchSetData() {
        }

        @VisibleForTesting
        static PatchSetData create(ChangeData cd, PatchSet ps, RevCommit commit) {
            return new AutoValue_RelatedChangesSorter_PatchSetData(cd, ps, commit);
        }

        abstract ChangeData data();

        abstract PatchSet patchSet();

        abstract RevCommit commit();

        PatchSet.Id psId() {
            return this.patchSet().getId();
        }

        Change.Id id() {
            return this.psId().getParentKey();
        }

        public int hashCode() {
            return Objects.hash(this.patchSet().getId(), this.commit());
        }
    }
}

