/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.index.IndexModule;
import com.google.gerrit.server.index.SingleVersionModule;
import com.google.gerrit.server.index.VersionManager;
import com.google.gerrit.server.index.account.AccountIndex;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Map;
import org.eclipse.jgit.lib.Config;

public abstract class AbstractIndexModule
extends AbstractModule {
    private final int threads;
    private final Map<String, Integer> singleVersions;

    protected AbstractIndexModule(Map<String, Integer> singleVersions, int threads) {
        this.singleVersions = singleVersions;
        this.threads = threads;
    }

    @Override
    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(AccountIndex.class, this.getAccountIndex()).build(AccountIndex.Factory.class));
        this.install(new FactoryModuleBuilder().implement(ChangeIndex.class, this.getChangeIndex()).build(ChangeIndex.Factory.class));
        this.install(new FactoryModuleBuilder().implement(GroupIndex.class, this.getGroupIndex()).build(GroupIndex.Factory.class));
        this.install(new IndexModule(this.threads));
        if (this.singleVersions == null) {
            this.install(new MultiVersionModule());
        } else {
            this.install(new SingleVersionModule(this.singleVersions));
        }
    }

    protected abstract Class<? extends AccountIndex> getAccountIndex();

    protected abstract Class<? extends ChangeIndex> getChangeIndex();

    protected abstract Class<? extends GroupIndex> getGroupIndex();

    protected abstract Class<? extends VersionManager> getVersionManager();

    @Provides
    @Singleton
    IndexConfig provideIndexConfig(@GerritServerConfig Config cfg) {
        return this.getIndexConfig(cfg);
    }

    protected IndexConfig getIndexConfig(@GerritServerConfig Config cfg) {
        return IndexConfig.fromConfig(cfg).separateChangeSubIndexes(true).build();
    }

    private class MultiVersionModule
    extends LifecycleModule {
        private MultiVersionModule() {
        }

        @Override
        public void configure() {
            Class<? extends VersionManager> versionManagerClass = AbstractIndexModule.this.getVersionManager();
            this.bind(VersionManager.class).to(versionManagerClass);
            this.listener().to(versionManagerClass);
        }
    }
}

