/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.IndexRewriter;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.Schema;
import com.google.gerrit.index.query.AndPredicate;
import com.google.gerrit.index.query.IndexPredicate;
import com.google.gerrit.index.query.LimitPredicate;
import com.google.gerrit.index.query.NotPredicate;
import com.google.gerrit.index.query.OrPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.IndexedChangeQuery;
import com.google.gerrit.server.query.change.AndChangeSource;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gerrit.server.query.change.OrSource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.util.MutableInteger;

@Singleton
public class ChangeIndexRewriter
implements IndexRewriter<ChangeData> {
    public static final Set<Change.Status> OPEN_STATUSES;
    public static final Set<Change.Status> CLOSED_STATUSES;
    private final ChangeIndexCollection indexes;
    private final IndexConfig config;

    public static EnumSet<Change.Status> getPossibleStatus(Predicate<ChangeData> in) {
        EnumSet<Change.Status> s = ChangeIndexRewriter.extractStatus(in);
        return s != null ? s : EnumSet.allOf(Change.Status.class);
    }

    private static EnumSet<Change.Status> extractStatus(Predicate<ChangeData> in) {
        if (in instanceof ChangeStatusPredicate) {
            Change.Status status = ((ChangeStatusPredicate)in).getStatus();
            return status != null ? EnumSet.of(status) : null;
        }
        if (in instanceof NotPredicate) {
            EnumSet<Change.Status> s = ChangeIndexRewriter.extractStatus(in.getChild(0));
            return s != null ? EnumSet.complementOf(s) : null;
        }
        if (in instanceof OrPredicate) {
            EnumSet<Change.Status> r = null;
            int childrenWithStatus = 0;
            for (int i = 0; i < in.getChildCount(); ++i) {
                EnumSet<Change.Status> c = ChangeIndexRewriter.extractStatus(in.getChild(i));
                if (c == null) continue;
                if (r == null) {
                    r = EnumSet.noneOf(Change.Status.class);
                }
                r.addAll(c);
                ++childrenWithStatus;
            }
            if (r != null && childrenWithStatus < in.getChildCount()) {
                return EnumSet.allOf(Change.Status.class);
            }
            return r;
        }
        if (in instanceof AndPredicate) {
            EnumSet<Change.Status> r = null;
            for (int i = 0; i < in.getChildCount(); ++i) {
                EnumSet<Change.Status> c = ChangeIndexRewriter.extractStatus(in.getChild(i));
                if (c == null) continue;
                if (r == null) {
                    r = EnumSet.allOf(Change.Status.class);
                }
                r.retainAll(c);
            }
            return r;
        }
        return null;
    }

    @Inject
    ChangeIndexRewriter(ChangeIndexCollection indexes, IndexConfig config) {
        this.indexes = indexes;
        this.config = config;
    }

    @Override
    public Predicate<ChangeData> rewrite(Predicate<ChangeData> in, QueryOptions opts) throws QueryParseException {
        Predicate<ChangeData> s = this.rewriteImpl(in, opts);
        if (!(s instanceof ChangeDataSource)) {
            in = Predicate.and(ChangeStatusPredicate.open(), in);
            s = this.rewriteImpl(in, opts);
        }
        if (!(s instanceof ChangeDataSource)) {
            throw new QueryParseException("invalid query: " + s);
        }
        return s;
    }

    private Predicate<ChangeData> rewriteImpl(Predicate<ChangeData> in, QueryOptions opts) throws QueryParseException {
        MutableInteger leafTerms;
        ChangeIndex index = (ChangeIndex)this.indexes.getSearchIndex();
        Predicate<ChangeData> out = this.rewriteImpl(in, index, opts, leafTerms = new MutableInteger());
        if (in == out || out instanceof IndexPredicate) {
            return new IndexedChangeQuery(index, out, opts);
        }
        if (out == null) {
            return in;
        }
        return out;
    }

    private Predicate<ChangeData> rewriteImpl(Predicate<ChangeData> in, ChangeIndex index, QueryOptions opts, MutableInteger leafTerms) throws QueryParseException {
        if (this.isIndexPredicate(in, index)) {
            if (++leafTerms.value > this.config.maxTerms()) {
                throw new QueryParseException("too many terms in query");
            }
            return in;
        }
        if (in instanceof LimitPredicate) {
            return new LimitPredicate<ChangeData>("limit", opts.limit());
        }
        if (!ChangeIndexRewriter.isRewritePossible(in)) {
            if (in instanceof IndexPredicate) {
                throw new QueryParseException("Unsupported index predicate: " + in.toString());
            }
            return null;
        }
        int n = in.getChildCount();
        BitSet isIndexed = new BitSet(n);
        BitSet notIndexed = new BitSet(n);
        BitSet rewritten = new BitSet(n);
        BitSet changeSource = new BitSet(n);
        ArrayList<Predicate<ChangeData>> newChildren = Lists.newArrayListWithCapacity(n);
        for (int i = 0; i < n; ++i) {
            Predicate<ChangeData> c = in.getChild(i);
            Predicate<ChangeData> nc = this.rewriteImpl(c, index, opts, leafTerms);
            if (nc == c) {
                isIndexed.set(i);
                newChildren.add(c);
                continue;
            }
            if (nc == null) {
                notIndexed.set(i);
                newChildren.add(c);
                continue;
            }
            if (nc instanceof ChangeDataSource) {
                changeSource.set(i);
            }
            rewritten.set(i);
            newChildren.add(nc);
        }
        if (isIndexed.cardinality() == n) {
            return in;
        }
        if (notIndexed.cardinality() == n) {
            return null;
        }
        if (rewritten.cardinality() == n) {
            if (changeSource.cardinality() == n) {
                return this.copy(in, newChildren);
            }
            return in.copy(newChildren);
        }
        return this.partitionChildren(in, newChildren, isIndexed, index, opts);
    }

    private boolean isIndexPredicate(Predicate<ChangeData> in, ChangeIndex index) {
        if (!(in instanceof IndexPredicate)) {
            return false;
        }
        IndexPredicate p = (IndexPredicate)in;
        FieldDef def = p.getField();
        Schema schema = index.getSchema();
        return schema.hasField(def);
    }

    private Predicate<ChangeData> partitionChildren(Predicate<ChangeData> in, List<Predicate<ChangeData>> newChildren, BitSet isIndexed, ChangeIndex index, QueryOptions opts) throws QueryParseException {
        if (isIndexed.cardinality() == 1) {
            int i = isIndexed.nextSetBit(0);
            newChildren.add(0, new IndexedChangeQuery(index, newChildren.remove(i), opts));
            return this.copy(in, newChildren);
        }
        ArrayList<Predicate<ChangeData>> indexed = Lists.newArrayListWithCapacity(isIndexed.cardinality());
        ArrayList<Predicate<ChangeData>> all = Lists.newArrayListWithCapacity(newChildren.size() - isIndexed.cardinality() + 1);
        for (int i = 0; i < newChildren.size(); ++i) {
            Predicate<ChangeData> c = newChildren.get(i);
            if (isIndexed.get(i)) {
                indexed.add(c);
                continue;
            }
            all.add(c);
        }
        all.add(0, new IndexedChangeQuery(index, in.copy(indexed), opts));
        return this.copy(in, all);
    }

    private Predicate<ChangeData> copy(Predicate<ChangeData> in, List<Predicate<ChangeData>> all) {
        if (in instanceof AndPredicate) {
            return new AndChangeSource((Collection<Predicate<ChangeData>>)all);
        }
        if (in instanceof OrPredicate) {
            return new OrSource((Collection<? extends Predicate<ChangeData>>)all);
        }
        return in.copy(all);
    }

    private static boolean isRewritePossible(Predicate<ChangeData> p) {
        return p.getChildCount() > 0 && (p instanceof AndPredicate || p instanceof OrPredicate || p instanceof NotPredicate);
    }

    static {
        EnumSet<Change.Status> open = EnumSet.noneOf(Change.Status.class);
        EnumSet<Change.Status> closed = EnumSet.noneOf(Change.Status.class);
        for (Change.Status s : Change.Status.values()) {
            if (s.isOpen()) {
                open.add(s);
                continue;
            }
            closed.add(s);
        }
        OPEN_STATUSES = Sets.immutableEnumSet(open);
        CLOSED_STATUSES = Sets.immutableEnumSet(closed);
    }
}

