/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.gerrit.metrics.Counter1;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
class NoteDbMetrics {
    final Timer1<NoteDbTable> updateLatency;
    final Timer1<NoteDbTable> stageUpdateLatency;
    final Timer1<NoteDbTable> readLatency;
    final Timer1<NoteDbTable> parseLatency;
    final Timer1<NoteDbTable> autoRebuildLatency;
    final Counter1<NoteDbTable> autoRebuildFailureCount;

    @Inject
    NoteDbMetrics(MetricMaker metrics) {
        Field<NoteDbTable> view = Field.ofEnum(NoteDbTable.class, "table");
        this.updateLatency = metrics.newTimer("notedb/update_latency", new Description("NoteDb update latency by table").setCumulative().setUnit("milliseconds"), view);
        this.stageUpdateLatency = metrics.newTimer("notedb/stage_update_latency", new Description("Latency for staging updates to NoteDb by table").setCumulative().setUnit("microseconds"), view);
        this.readLatency = metrics.newTimer("notedb/read_latency", new Description("NoteDb read latency by table").setCumulative().setUnit("milliseconds"), view);
        this.parseLatency = metrics.newTimer("notedb/parse_latency", new Description("NoteDb parse latency by table").setCumulative().setUnit("microseconds"), view);
        this.autoRebuildLatency = metrics.newTimer("notedb/auto_rebuild_latency", new Description("NoteDb auto-rebuilding latency by table").setCumulative().setUnit("milliseconds"), view);
        this.autoRebuildFailureCount = metrics.newCounter("notedb/auto_rebuild_failure_count", new Description("NoteDb auto-rebuilding attempts that failed by table").setCumulative(), view);
    }
}

