/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.gerrit.server.notedb.rebuild.Event;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;

class EventSorter {
    private final List<Event> out;
    private final LinkedHashSet<Event> sorted;
    private ListMultimap<Event, Event> waiting;
    private SetMultimap<Event, Event> deps;

    EventSorter(List<Event> events) {
        LinkedHashSet<Event> all = new LinkedHashSet<Event>(events);
        this.out = events;
        for (Event e : events) {
            for (Event d : e.deps) {
                Preconditions.checkArgument(all.contains(d), "dep %s of %s not in input list", (Object)d, (Object)e);
            }
        }
        all.clear();
        this.sorted = all;
    }

    void sort() {
        PriorityQueue<Event> todo = new PriorityQueue<Event>(this.out);
        this.waiting = MultimapBuilder.hashKeys().arrayListValues().build();
        this.deps = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Event e : todo) {
            for (Event d : e.deps) {
                this.deps.put(e, d);
                this.waiting.put(d, e);
            }
        }
        int size = this.out.size();
        while (!todo.isEmpty()) {
            this.process((Event)todo.remove(), todo);
        }
        Preconditions.checkState(this.sorted.size() == size, "event sort expected %s elements, got %s", size, this.sorted.size());
        this.out.clear();
        this.out.addAll(this.sorted);
    }

    void process(Event e, PriorityQueue<Event> todo) {
        if (this.sorted.contains(e)) {
            return;
        }
        if (!this.deps.get((Object)e).isEmpty()) {
            return;
        }
        this.sorted.add(e);
        for (Event w : this.waiting.get((Object)e)) {
            this.deps.get((Object)w).remove(e);
            todo.add(w);
        }
    }
}

