/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.server.ioutil.BasicSerialization;
import com.google.gerrit.server.query.change.ChangeData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class DiffSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient String[] paths;
    private transient int insertions;
    private transient int deletions;

    public DiffSummary(String[] paths, int insertions, int deletions) {
        this.paths = paths;
        this.insertions = insertions;
        this.deletions = deletions;
    }

    public List<String> getPaths() {
        return Collections.unmodifiableList(Arrays.asList(this.paths));
    }

    public ChangeData.ChangedLines getChangedLines() {
        return new ChangeData.ChangedLines(this.insertions, this.deletions);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        BasicSerialization.writeVarInt32(output, this.insertions);
        BasicSerialization.writeVarInt32(output, this.deletions);
        BasicSerialization.writeVarInt32(output, this.paths.length);
        try (DeflaterOutputStream out = new DeflaterOutputStream(output);){
            for (String p : this.paths) {
                BasicSerialization.writeString(out, p);
            }
        }
    }

    private void readObject(ObjectInputStream input) throws IOException {
        this.insertions = BasicSerialization.readVarInt32(input);
        this.deletions = BasicSerialization.readVarInt32(input);
        this.paths = new String[BasicSerialization.readVarInt32(input)];
        try (InflaterInputStream in = new InflaterInputStream(input);){
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = BasicSerialization.readString(in);
            }
        }
    }
}

