/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gerrit.server.patch.AutoValue_EditTransformer_ContextAwareEdit;
import com.google.gerrit.server.patch.PatchListEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.diff.Edit;

class EditTransformer {
    private List<ContextAwareEdit> edits;

    public EditTransformer(List<PatchListEntry> patchListEntries) {
        this.edits = patchListEntries.stream().flatMap(EditTransformer::toEdits).collect(ImmutableList.toImmutableList());
    }

    public void transformReferencesOfSideA(List<PatchListEntry> transformationEntries) {
        this.transformEdits(transformationEntries, SideAStrategy.INSTANCE);
    }

    public void transformReferencesOfSideB(List<PatchListEntry> transformationEntries) {
        this.transformEdits(transformationEntries, SideBStrategy.INSTANCE);
    }

    public Multimap<String, ContextAwareEdit> getEditsPerFilePath() {
        return this.edits.stream().collect(Multimaps.toMultimap(ContextAwareEdit::getNewFilePath, Function.identity(), ArrayListMultimap::create));
    }

    public static Stream<ContextAwareEdit> toEdits(PatchListEntry patchListEntry) {
        ImmutableList<Edit> edits = patchListEntry.getEdits();
        if (edits.isEmpty()) {
            return Stream.of(ContextAwareEdit.createForNoContentEdit(patchListEntry));
        }
        return edits.stream().map(edit -> ContextAwareEdit.create(patchListEntry, edit));
    }

    private void transformEdits(List<PatchListEntry> transformingEntries, SideStrategy sideStrategy) {
        Map<String, List<ContextAwareEdit>> editsPerFilePath = this.edits.stream().collect(Collectors.groupingBy(sideStrategy::getFilePath));
        Map<String, List<PatchListEntry>> transEntriesPerPath = transformingEntries.stream().collect(Collectors.groupingBy(EditTransformer::getOldFilePath));
        this.edits = editsPerFilePath.entrySet().stream().flatMap(pathAndEdits -> {
            List transEntries = transEntriesPerPath.getOrDefault(pathAndEdits.getKey(), ImmutableList.of());
            return EditTransformer.transformEdits(sideStrategy, (List)pathAndEdits.getValue(), transEntries);
        }).collect(Collectors.toList());
    }

    private static String getOldFilePath(PatchListEntry patchListEntry) {
        return MoreObjects.firstNonNull(patchListEntry.getOldName(), patchListEntry.getNewName());
    }

    private static Stream<ContextAwareEdit> transformEdits(SideStrategy sideStrategy, List<ContextAwareEdit> originalEdits, List<PatchListEntry> transformingEntries) {
        if (transformingEntries.isEmpty()) {
            return originalEdits.stream();
        }
        return transformingEntries.stream().flatMap(transEntry -> EditTransformer.transformEdits(sideStrategy, originalEdits, transEntry.getEdits(), transEntry.getNewName()).stream());
    }

    private static List<ContextAwareEdit> transformEdits(SideStrategy sideStrategy, List<ContextAwareEdit> unorderedOriginalEdits, List<Edit> unorderedTransformingEdits, String adjustedFilePath) {
        ArrayList<ContextAwareEdit> originalEdits = new ArrayList<ContextAwareEdit>(unorderedOriginalEdits);
        originalEdits.sort(Comparator.comparing(sideStrategy::getBegin).thenComparing(sideStrategy::getEnd));
        ArrayList<Edit> transformingEdits = new ArrayList<Edit>(unorderedTransformingEdits);
        transformingEdits.sort(Comparator.comparing(Edit::getBeginA).thenComparing(Edit::getEndA));
        int shiftedAmount = 0;
        int transIndex = 0;
        int origIndex = 0;
        ArrayList<ContextAwareEdit> resultingEdits = new ArrayList<ContextAwareEdit>(originalEdits.size());
        while (origIndex < originalEdits.size() && transIndex < transformingEdits.size()) {
            ContextAwareEdit originalEdit = (ContextAwareEdit)originalEdits.get(origIndex);
            Edit transformingEdit = (Edit)transformingEdits.get(transIndex);
            if (transformingEdit.getEndA() <= sideStrategy.getBegin(originalEdit)) {
                shiftedAmount = transformingEdit.getEndB() - transformingEdit.getEndA();
                ++transIndex;
                continue;
            }
            if (sideStrategy.getEnd(originalEdit) <= transformingEdit.getBeginA()) {
                resultingEdits.add(sideStrategy.create(originalEdit, shiftedAmount, adjustedFilePath));
                ++origIndex;
                continue;
            }
            ++origIndex;
        }
        for (int i = origIndex; i < originalEdits.size(); ++i) {
            resultingEdits.add(sideStrategy.create((ContextAwareEdit)originalEdits.get(i), shiftedAmount, adjustedFilePath));
        }
        return resultingEdits;
    }

    private static enum SideBStrategy implements SideStrategy
    {
        INSTANCE;


        @Override
        public String getFilePath(ContextAwareEdit edit) {
            return edit.getNewFilePath();
        }

        @Override
        public int getBegin(ContextAwareEdit edit) {
            return edit.getBeginB();
        }

        @Override
        public int getEnd(ContextAwareEdit edit) {
            return edit.getEndB();
        }

        @Override
        public ContextAwareEdit create(ContextAwareEdit edit, int shiftedAmount, String adjustedFilePath) {
            return ContextAwareEdit.create(edit.getOldFilePath(), adjustedFilePath, edit.getBeginA(), edit.getEndA(), edit.getBeginB() + shiftedAmount, edit.getEndB() + shiftedAmount, !Objects.equals(edit.getNewFilePath(), adjustedFilePath));
        }
    }

    private static enum SideAStrategy implements SideStrategy
    {
        INSTANCE;


        @Override
        public String getFilePath(ContextAwareEdit edit) {
            return edit.getOldFilePath();
        }

        @Override
        public int getBegin(ContextAwareEdit edit) {
            return edit.getBeginA();
        }

        @Override
        public int getEnd(ContextAwareEdit edit) {
            return edit.getEndA();
        }

        @Override
        public ContextAwareEdit create(ContextAwareEdit edit, int shiftedAmount, String adjustedFilePath) {
            return ContextAwareEdit.create(adjustedFilePath, edit.getNewFilePath(), edit.getBeginA() + shiftedAmount, edit.getEndA() + shiftedAmount, edit.getBeginB(), edit.getEndB(), !Objects.equals(edit.getOldFilePath(), adjustedFilePath));
        }
    }

    private static interface SideStrategy {
        public String getFilePath(ContextAwareEdit var1);

        public int getBegin(ContextAwareEdit var1);

        public int getEnd(ContextAwareEdit var1);

        public ContextAwareEdit create(ContextAwareEdit var1, int var2, String var3);
    }

    @AutoValue
    static abstract class ContextAwareEdit {
        ContextAwareEdit() {
        }

        static ContextAwareEdit create(PatchListEntry patchListEntry, Edit edit) {
            return ContextAwareEdit.create(patchListEntry.getOldName(), patchListEntry.getNewName(), edit.getBeginA(), edit.getEndA(), edit.getBeginB(), edit.getEndB(), false);
        }

        static ContextAwareEdit createForNoContentEdit(PatchListEntry patchListEntry) {
            return ContextAwareEdit.create(patchListEntry.getOldName(), patchListEntry.getNewName(), -1, -1, -1, -1, false);
        }

        static ContextAwareEdit create(String oldFilePath, String newFilePath, int beginA, int endA, int beginB, int endB, boolean filePathAdjusted) {
            String adjustedOldFilePath = MoreObjects.firstNonNull(oldFilePath, newFilePath);
            boolean implicitRename = !Objects.equals(oldFilePath, newFilePath) && filePathAdjusted;
            return new AutoValue_EditTransformer_ContextAwareEdit(adjustedOldFilePath, newFilePath, beginA, endA, beginB, endB, implicitRename);
        }

        public abstract String getOldFilePath();

        public abstract String getNewFilePath();

        public abstract int getBeginA();

        public abstract int getEndA();

        public abstract int getBeginB();

        public abstract int getEndB();

        public abstract boolean isImplicitRename();

        public Optional<Edit> toEdit() {
            if (this.getBeginA() < 0) {
                return Optional.empty();
            }
            return Optional.of(new Edit(this.getBeginA(), this.getEndA(), this.getBeginB(), this.getEndB()));
        }
    }
}

