/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.DeleteRef;
import com.google.gerrit.server.project.RefUtil;
import com.google.gerrit.server.project.TagResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class DeleteTag
implements RestModifyView<TagResource, Input> {
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final DeleteRef.Factory deleteRefFactory;

    @Inject
    DeleteTag(PermissionBackend permissionBackend, Provider<CurrentUser> user, DeleteRef.Factory deleteRefFactory) {
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.deleteRefFactory = deleteRefFactory;
    }

    public Response<?> apply(TagResource resource, Input input) throws OrmException, RestApiException, IOException, PermissionBackendException {
        String tag = RefUtil.normalizeTagRef(resource.getTagInfo().ref);
        this.permissionBackend.user(this.user).project(resource.getNameKey()).ref(tag).check(RefPermission.DELETE);
        this.deleteRefFactory.create(resource).ref(tag).delete();
        return Response.none();
    }

    public static class Input {
    }
}

