/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.index.query.QueryResult;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.QueryStatsAttribute;
import com.google.gerrit.server.events.EventFactory;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryProcessor;
import com.google.gson.Gson;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamQuery {
    private static final Logger log = LoggerFactory.getLogger(OutputStreamQuery.class);
    private static final DateTimeFormatter dtf = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss zzz");
    private final ReviewDb db;
    private final GitRepositoryManager repoManager;
    private final ChangeQueryBuilder queryBuilder;
    private final ChangeQueryProcessor queryProcessor;
    private final EventFactory eventFactory;
    private final TrackingFooters trackingFooters;
    private final CurrentUser user;
    private final SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory;
    private OutputFormat outputFormat = OutputFormat.TEXT;
    private boolean includePatchSets;
    private boolean includeCurrentPatchSet;
    private boolean includeApprovals;
    private boolean includeComments;
    private boolean includeFiles;
    private boolean includeCommitMessage;
    private boolean includeDependencies;
    private boolean includeSubmitRecords;
    private boolean includeAllReviewers;
    private OutputStream outputStream = DisabledOutputStream.INSTANCE;
    private PrintWriter out;

    @Inject
    OutputStreamQuery(ReviewDb db, GitRepositoryManager repoManager, ChangeQueryBuilder queryBuilder, ChangeQueryProcessor queryProcessor, EventFactory eventFactory, TrackingFooters trackingFooters, CurrentUser user, SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory) {
        this.db = db;
        this.repoManager = repoManager;
        this.queryBuilder = queryBuilder;
        this.queryProcessor = queryProcessor;
        this.eventFactory = eventFactory;
        this.trackingFooters = trackingFooters;
        this.user = user;
        this.submitRuleEvaluatorFactory = submitRuleEvaluatorFactory;
    }

    void setLimit(int n) {
        this.queryProcessor.setUserProvidedLimit(n);
    }

    public void setStart(int n) {
        this.queryProcessor.setStart(n);
    }

    public void setIncludePatchSets(boolean on) {
        this.includePatchSets = on;
    }

    public boolean getIncludePatchSets() {
        return this.includePatchSets;
    }

    public void setIncludeCurrentPatchSet(boolean on) {
        this.includeCurrentPatchSet = on;
    }

    public boolean getIncludeCurrentPatchSet() {
        return this.includeCurrentPatchSet;
    }

    public void setIncludeApprovals(boolean on) {
        this.includeApprovals = on;
    }

    public void setIncludeComments(boolean on) {
        this.includeComments = on;
    }

    public void setIncludeFiles(boolean on) {
        this.includeFiles = on;
    }

    public boolean getIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeDependencies(boolean on) {
        this.includeDependencies = on;
    }

    public boolean getIncludeDependencies() {
        return this.includeDependencies;
    }

    public void setIncludeCommitMessage(boolean on) {
        this.includeCommitMessage = on;
    }

    public void setIncludeSubmitRecords(boolean on) {
        this.includeSubmitRecords = on;
    }

    public void setIncludeAllReviewers(boolean on) {
        this.includeAllReviewers = on;
    }

    public void setOutput(OutputStream out, OutputFormat fmt) {
        this.outputStream = out;
        this.outputFormat = fmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String queryString) throws IOException {
        this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8)));
        try {
            if (this.queryProcessor.isDisabled()) {
                ErrorMessage m = new ErrorMessage();
                m.message = "query disabled";
                this.show(m);
                return;
            }
            try {
                QueryStatsAttribute stats = new QueryStatsAttribute();
                stats.runTimeMilliseconds = TimeUtil.nowMs();
                HashMap<Project.NameKey, Repository> repos = new HashMap<Project.NameKey, Repository>();
                HashMap<Project.NameKey, RevWalk> revWalks = new HashMap<Project.NameKey, RevWalk>();
                QueryResult results = this.queryProcessor.query(this.queryBuilder.parse(queryString));
                try {
                    for (ChangeData d : results.entities()) {
                        this.show(this.buildChangeAttribute(d, repos, revWalks));
                    }
                }
                finally {
                    OutputStreamQuery.closeAll(revWalks.values(), repos.values());
                }
                stats.rowCount = results.entities().size();
                stats.moreChanges = results.more();
                stats.runTimeMilliseconds = TimeUtil.nowMs() - stats.runTimeMilliseconds;
                this.show(stats);
            }
            catch (OrmException err) {
                log.error("Cannot execute query: " + queryString, err);
                ErrorMessage m = new ErrorMessage();
                m.message = "cannot query database";
                this.show(m);
            }
            catch (QueryParseException e) {
                ErrorMessage m = new ErrorMessage();
                m.message = e.getMessage();
                this.show(m);
            }
        }
        finally {
            try {
                this.out.flush();
            }
            finally {
                this.out = null;
            }
        }
    }

    private ChangeAttribute buildChangeAttribute(ChangeData d, Map<Project.NameKey, Repository> repos, Map<Project.NameKey, RevWalk> revWalks) throws OrmException, IOException {
        PatchSet current;
        Project.NameKey p;
        LabelTypes labelTypes = d.getLabelTypes();
        ChangeAttribute c = this.eventFactory.asChangeAttribute(this.db, d.change());
        this.eventFactory.extend(c, d.change());
        if (!this.trackingFooters.isEmpty()) {
            this.eventFactory.addTrackingIds(c, d.trackingFooters());
        }
        if (this.includeAllReviewers) {
            this.eventFactory.addAllReviewers(this.db, c, d.notes());
        }
        if (this.includeSubmitRecords) {
            this.eventFactory.addSubmitRecords(c, this.submitRuleEvaluatorFactory.create(this.user, d).setAllowClosed(true).evaluate());
        }
        if (this.includeCommitMessage) {
            this.eventFactory.addCommitMessage(c, d.commitMessage());
        }
        RevWalk rw = null;
        if ((this.includePatchSets || this.includeCurrentPatchSet || this.includeDependencies) && (rw = revWalks.get(p = d.change().getProject())) == null) {
            Repository repo = this.repoManager.openRepository(p);
            Preconditions.checkState(repos.put(p, repo) == null);
            rw = new RevWalk(repo);
            revWalks.put(p, rw);
        }
        if (this.includePatchSets) {
            this.eventFactory.addPatchSets(this.db, rw, c, d.patchSets(), this.includeApprovals ? d.approvals().asMap() : null, this.includeFiles, d.change(), labelTypes);
        }
        if (this.includeCurrentPatchSet && (current = d.currentPatchSet()) != null) {
            c.currentPatchSet = this.eventFactory.asPatchSetAttribute(this.db, rw, d.change(), current);
            this.eventFactory.addApprovals(c.currentPatchSet, d.currentApprovals(), labelTypes);
            if (this.includeFiles) {
                this.eventFactory.addPatchSetFileNames(c.currentPatchSet, d.change(), d.currentPatchSet());
            }
            if (this.includeComments) {
                this.eventFactory.addPatchSetComments(c.currentPatchSet, d.publishedComments());
            }
        }
        if (this.includeComments) {
            this.eventFactory.addComments(c, d.messages());
            if (this.includePatchSets) {
                this.eventFactory.addPatchSets(this.db, rw, c, d.patchSets(), this.includeApprovals ? d.approvals().asMap() : null, this.includeFiles, d.change(), labelTypes);
                for (PatchSetAttribute attribute : c.patchSets) {
                    this.eventFactory.addPatchSetComments(attribute, d.publishedComments());
                }
            }
        }
        if (this.includeDependencies) {
            this.eventFactory.addDependencies(rw, c, d.change(), d.currentPatchSet());
        }
        c.plugins = this.queryProcessor.create(d);
        return c;
    }

    private static void closeAll(Iterable<RevWalk> revWalks, Iterable<Repository> repos) {
        if (repos != null) {
            for (Repository repo : repos) {
                repo.close();
            }
        }
        if (revWalks != null) {
            for (RevWalk revWalk : revWalks) {
                revWalk.close();
            }
        }
    }

    private void show(Object data) {
        switch (this.outputFormat) {
            default: {
                if (data instanceof ChangeAttribute) {
                    this.out.print("change ");
                    this.out.print(((ChangeAttribute)data).id);
                    this.out.print("\n");
                    this.showText(data, 1);
                } else {
                    this.showText(data, 0);
                }
                this.out.print('\n');
                break;
            }
            case JSON: {
                this.out.print(new Gson().toJson(data));
                this.out.print('\n');
            }
        }
    }

    private void showText(Object data, int depth) {
        for (Field f : this.fieldsOf(data.getClass())) {
            Object val;
            try {
                val = f.get(data);
            }
            catch (IllegalArgumentException err) {
                continue;
            }
            catch (IllegalAccessException err) {
                continue;
            }
            if (val == null) continue;
            this.showField(f.getName(), val, depth);
        }
    }

    private String indent(int spaces) {
        if (spaces == 0) {
            return "";
        }
        return String.format("%" + spaces + "s", " ");
    }

    private void showField(String field, Object value, int depth) {
        int spacesDepthRatio = 2;
        String indent = this.indent(depth * 2);
        this.out.print(indent);
        this.out.print(field);
        this.out.print(':');
        if (value instanceof String && ((String)value).contains("\n")) {
            this.out.print(' ');
            indent = this.indent(indent.length() + field.length() + 2);
            this.out.print(((String)value).replaceAll("\n", "\n" + indent).trim());
            this.out.print('\n');
        } else if (value instanceof Long && OutputStreamQuery.isDateField(field)) {
            this.out.print(' ');
            this.out.print(dtf.print((Long)value * 1000L));
            this.out.print('\n');
        } else if (OutputStreamQuery.isPrimitive(value)) {
            this.out.print(' ');
            this.out.print(value);
            this.out.print('\n');
        } else if (value instanceof Collection) {
            this.out.print('\n');
            boolean firstElement = true;
            for (Object thing : (Collection)value) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    this.out.print(indent);
                    this.out.print(field);
                    this.out.print(":\n");
                }
                if (OutputStreamQuery.isPrimitive(thing)) {
                    this.out.print(' ');
                    this.out.print(value);
                    this.out.print('\n');
                    continue;
                }
                this.showText(thing, depth + 1);
            }
        } else {
            this.out.print('\n');
            this.showText(value, depth + 1);
        }
    }

    private static boolean isPrimitive(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Enum;
    }

    private static boolean isDateField(String name) {
        return "lastUpdated".equals(name) || "grantedOn".equals(name) || "timestamp".equals(name) || "createdOn".equals(name);
    }

    private List<Field> fieldsOf(Class<?> type) {
        ArrayList<Field> r = new ArrayList<Field>();
        if (type.getSuperclass() != null) {
            r.addAll(this.fieldsOf(type.getSuperclass()));
        }
        r.addAll(Arrays.asList(type.getDeclaredFields()));
        return r;
    }

    static class ErrorMessage {
        public final String type = "error";
        public String message;

        ErrorMessage() {
        }
    }

    public static enum OutputFormat {
        TEXT,
        JSON;

    }
}

