/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.Set;
import java.util.stream.Collectors;

public class SubmitRecordPredicate
extends ChangeIndexPredicate {
    public static Predicate<ChangeData> create(String label, SubmitRecord.Label.Status status, Set<Account.Id> accounts) {
        String lowerLabel = label.toLowerCase();
        if (accounts == null || accounts.isEmpty()) {
            return new SubmitRecordPredicate(status.name() + ',' + lowerLabel);
        }
        return Predicate.or(accounts.stream().map(a -> new SubmitRecordPredicate(status.name() + ',' + lowerLabel + ',' + a.get())).collect(Collectors.toList()));
    }

    private SubmitRecordPredicate(String value) {
        super(ChangeField.SUBMIT_RECORD, value);
    }

    @Override
    public boolean match(ChangeData in) throws OrmException {
        return ChangeField.formatSubmitRecordValues(in).contains(this.getValue());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

