/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.query.LimitPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryBuilder;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupField;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.query.group.GroupPredicates;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class GroupQueryBuilder
extends QueryBuilder<InternalGroup> {
    public static final String FIELD_UUID = "uuid";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_INNAME = "inname";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_LIMIT = "limit";
    private static final QueryBuilder.Definition<InternalGroup, GroupQueryBuilder> mydef = new QueryBuilder.Definition(GroupQueryBuilder.class);
    private final Arguments args;

    @Inject
    GroupQueryBuilder(Arguments args) {
        super(mydef);
        this.args = args;
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> uuid(String uuid) {
        return GroupPredicates.uuid(new AccountGroup.UUID(uuid));
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> description(String description) throws QueryParseException {
        if (Strings.isNullOrEmpty(description)) {
            throw GroupQueryBuilder.error("description operator requires a value");
        }
        return GroupPredicates.description(description);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> inname(String namePart) {
        if (namePart.isEmpty()) {
            return this.name(namePart);
        }
        return GroupPredicates.inname(namePart);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> name(String name) {
        return GroupPredicates.name(name);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> owner(String owner) throws QueryParseException {
        AccountGroup.UUID groupUuid = this.parseGroup(owner);
        return GroupPredicates.owner(groupUuid);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> is(String value) throws QueryParseException {
        if ("visibletoall".equalsIgnoreCase(value)) {
            return GroupPredicates.isVisibleToAll();
        }
        throw GroupQueryBuilder.error("Invalid query");
    }

    @Override
    protected Predicate<InternalGroup> defaultField(String query) throws QueryParseException {
        ArrayList<Predicate<InternalGroup>> preds = Lists.newArrayListWithCapacity(5);
        preds.add(this.uuid(query));
        preds.add(this.name(query));
        preds.add(this.inname(query));
        if (!Strings.isNullOrEmpty(query)) {
            preds.add(this.description(query));
        }
        try {
            preds.add(this.owner(query));
        }
        catch (QueryParseException queryParseException) {
            // empty catch block
        }
        return Predicate.or(preds);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> member(String query) throws QueryParseException, OrmException, ConfigInvalidException, IOException {
        if (this.isFieldAbsentFromIndex(GroupField.MEMBER)) {
            throw GroupQueryBuilder.getExceptionForUnsupportedOperator("member");
        }
        Set<Account.Id> accounts = this.parseAccount(query);
        List predicates = accounts.stream().map(GroupPredicates::member).collect(ImmutableList.toImmutableList());
        return Predicate.or(predicates);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> subgroup(String query) throws QueryParseException {
        if (this.isFieldAbsentFromIndex(GroupField.SUBGROUP)) {
            throw GroupQueryBuilder.getExceptionForUnsupportedOperator("subgroup");
        }
        AccountGroup.UUID groupUuid = this.parseGroup(query);
        return GroupPredicates.subgroup(groupUuid);
    }

    @QueryBuilder.Operator
    public Predicate<InternalGroup> limit(String query) throws QueryParseException {
        Integer limit = Ints.tryParse(query);
        if (limit == null) {
            throw GroupQueryBuilder.error("Invalid limit: " + query);
        }
        return new LimitPredicate<InternalGroup>(FIELD_LIMIT, limit);
    }

    private boolean isFieldAbsentFromIndex(FieldDef<InternalGroup, ?> field) {
        return !this.args.groupIndex.getSchema().hasField(field);
    }

    private static QueryParseException getExceptionForUnsupportedOperator(String operatorName) {
        return new QueryParseException(String.format("'%s' operator is not supported by group index version", operatorName));
    }

    private Set<Account.Id> parseAccount(String nameOrEmail) throws QueryParseException, OrmException, IOException, ConfigInvalidException {
        Set<Account.Id> foundAccounts = this.args.accountResolver.findAll(nameOrEmail);
        if (foundAccounts.isEmpty()) {
            throw GroupQueryBuilder.error("User " + nameOrEmail + " not found");
        }
        return foundAccounts;
    }

    private AccountGroup.UUID parseGroup(String groupNameOrUuid) throws QueryParseException {
        Optional<InternalGroup> group = this.args.groupCache.get(new AccountGroup.UUID(groupNameOrUuid));
        if (group.isPresent()) {
            return group.get().getGroupUUID();
        }
        GroupReference groupReference = GroupBackends.findBestSuggestion(this.args.groupBackend, groupNameOrUuid);
        if (groupReference == null) {
            throw GroupQueryBuilder.error("Group " + groupNameOrUuid + " not found");
        }
        return groupReference.getUUID();
    }

    public static class Arguments {
        final GroupIndex groupIndex;
        final GroupCache groupCache;
        final GroupBackend groupBackend;
        final AccountResolver accountResolver;

        @Inject
        Arguments(GroupIndexCollection groupIndexCollection, GroupCache groupCache, GroupBackend groupBackend, AccountResolver accountResolver) {
            this.groupIndex = (GroupIndex)groupIndexCollection.getSearchIndex();
            this.groupCache = groupCache;
            this.groupBackend = groupBackend;
            this.accountResolver = accountResolver;
        }
    }
}

