/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.AclUtil;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_127;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_128
extends SchemaVersion {
    private static final String COMMIT_MSG = "Add addPatchSet permission to all projects";
    private final GitRepositoryManager repoManager;
    private final AllProjectsName allProjectsName;
    private final SystemGroupBackend systemGroupBackend;
    private final PersonIdent serverUser;

    @Inject
    Schema_128(Provider<Schema_127> prior, GitRepositoryManager repoManager, AllProjectsName allProjectsName, SystemGroupBackend systemGroupBackend, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allProjectsName = allProjectsName;
        this.systemGroupBackend = systemGroupBackend;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try (Repository git = this.repoManager.openRepository(this.allProjectsName);
             MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjectsName, git);){
            ProjectConfig config = ProjectConfig.read(md);
            GroupReference registered = this.systemGroupBackend.getGroup(SystemGroupBackend.REGISTERED_USERS);
            AccessSection refsFor = config.getAccessSection("refs/for/*", true);
            AclUtil.grant(config, refsFor, "addPatchSet", false, false, registered);
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            md.setMessage(COMMIT_MSG);
            config.commit(md);
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }
}

