/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_145;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_146
extends SchemaVersion {
    private static final String CREATE_ACCOUNT_MSG = "Create Account";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverIdent;

    @Inject
    Schema_146(Provider<Schema_145> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(repo);
             ObjectInserter oi = repo.newObjectInserter();){
            ObjectId emptyTree = Schema_146.emptyTree(oi);
            for (Map.Entry<Account.Id, Timestamp> e : this.scanAccounts(db).entrySet()) {
                String refName = RefNames.refsUsers(e.getKey());
                Ref ref = repo.exactRef(refName);
                if (ref != null) {
                    this.rewriteUserBranch(repo, rw, oi, emptyTree, ref, e.getValue());
                    continue;
                }
                this.createUserBranch(repo, oi, emptyTree, e.getKey(), e.getValue());
            }
        }
        catch (IOException e) {
            throw new OrmException("Failed to rewrite user branches.", e);
        }
    }

    private void rewriteUserBranch(Repository repo, RevWalk rw, ObjectInserter oi, ObjectId emptyTree, Ref ref, Timestamp registeredOn) throws IOException {
        RevCommit c;
        ObjectId current = this.createInitialEmptyCommit(oi, emptyTree, registeredOn);
        rw.reset();
        rw.sort(RevSort.TOPO);
        rw.sort(RevSort.REVERSE, true);
        rw.markStart(rw.parseCommit(ref.getObjectId()));
        while ((c = rw.next()) != null) {
            if (this.isInitialEmptyCommit(emptyTree, c)) {
                return;
            }
            CommitBuilder cb = new CommitBuilder();
            cb.setParentId(current);
            cb.setTreeId(c.getTree());
            cb.setAuthor(c.getAuthorIdent());
            cb.setCommitter(c.getCommitterIdent());
            cb.setMessage(c.getFullMessage());
            cb.setEncoding(c.getEncoding());
            current = oi.insert(cb);
        }
        oi.flush();
        RefUpdate ru = repo.updateRef(ref.getName());
        ru.setExpectedOldObjectId(ref.getObjectId());
        ru.setNewObjectId(current);
        ru.setForceUpdate(true);
        ru.setRefLogIdent(this.serverIdent);
        ru.setRefLogMessage(this.getClass().getSimpleName(), true);
        RefUpdate.Result result = ru.update();
        if (result != RefUpdate.Result.FORCED) {
            throw new IOException(String.format("Failed to update ref %s: %s", ref.getName(), result.name()));
        }
    }

    public void createUserBranch(Repository repo, ObjectInserter oi, ObjectId emptyTree, Account.Id accountId, Timestamp registeredOn) throws IOException {
        ObjectId id = this.createInitialEmptyCommit(oi, emptyTree, registeredOn);
        String refName = RefNames.refsUsers(accountId);
        RefUpdate ru = repo.updateRef(refName);
        ru.setExpectedOldObjectId(ObjectId.zeroId());
        ru.setNewObjectId(id);
        ru.setRefLogIdent(this.serverIdent);
        ru.setRefLogMessage(CREATE_ACCOUNT_MSG, false);
        RefUpdate.Result result = ru.update();
        if (result != RefUpdate.Result.NEW) {
            throw new IOException(String.format("Failed to update ref %s: %s", refName, result.name()));
        }
    }

    private ObjectId createInitialEmptyCommit(ObjectInserter oi, ObjectId emptyTree, Timestamp registrationDate) throws IOException {
        PersonIdent ident = new PersonIdent(this.serverIdent, registrationDate);
        CommitBuilder cb = new CommitBuilder();
        cb.setTreeId(emptyTree);
        cb.setCommitter(ident);
        cb.setAuthor(ident);
        cb.setMessage(CREATE_ACCOUNT_MSG);
        return oi.insert(cb);
    }

    private boolean isInitialEmptyCommit(ObjectId emptyTree, RevCommit c) {
        return c.getParentCount() == 0 && c.getTree().equals(emptyTree) && c.getShortMessage().equals(CREATE_ACCOUNT_MSG);
    }

    private static ObjectId emptyTree(ObjectInserter oi) throws IOException {
        return oi.insert(2, new byte[0]);
    }

    /*
     * Exception decompiling
     */
    private Map<Account.Id, Timestamp> scanAccounts(ReviewDb db) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

