/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class GuiceRequestScopePropagator
extends RequestScopePropagator {
    private final String url;
    private final SocketAddress peer;

    @Inject
    GuiceRequestScopePropagator(@CanonicalWebUrl @Nullable Provider<String> urlProvider, @RemotePeer Provider<SocketAddress> remotePeerProvider, ThreadLocalRequestContext local, Provider<RequestScopedReviewDbProvider> dbProviderProvider) {
        super(ServletScopes.REQUEST, local, dbProviderProvider);
        this.url = urlProvider != null ? urlProvider.get() : null;
        this.peer = remotePeerProvider.get();
    }

    @Override
    protected <T> Callable<T> wrapImpl(Callable<T> callable) {
        HashMap seedMap = new HashMap();
        seedMap.put(Key.get((Type)this.typeOfProvider((Type)((Object)String.class)), CanonicalWebUrl.class), Providers.of(this.url));
        seedMap.put(Key.get(String.class, CanonicalWebUrl.class), this.url);
        seedMap.put(Key.get((Type)this.typeOfProvider((Type)((Object)SocketAddress.class)), RemotePeer.class), Providers.of(this.peer));
        seedMap.put(Key.get(SocketAddress.class, RemotePeer.class), this.peer);
        return ServletScopes.continueRequest(callable, seedMap);
    }

    private ParameterizedType typeOfProvider(Type type) {
        return Types.newParameterizedType(Provider.class, new Type[]{type});
    }
}

