/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeScripts;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeStyleSheets;
import com.google.common.html.types.SafeStyles;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.html.types.TrustedResourceUrls;
import com.google.common.html.types.UncheckedConversions;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.internal.RenderableThunk;
import com.google.template.soy.data.restricted.SoyString;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public abstract class SanitizedContent
extends SoyData
implements SoyString {
    private final ContentKind contentKind;
    private final Dir contentDir;

    static SanitizedContent create(String content, ContentKind kind, @Nullable Dir dir) {
        return new ConstantContent(content, kind, dir);
    }

    static SanitizedContent createLazy(RenderableThunk thunk, ContentKind kind, @Nullable Dir dir) {
        return new LazyContent(thunk, kind, dir);
    }

    private SanitizedContent(ContentKind contentKind, @Nullable Dir contentDir) {
        this.contentKind = contentKind;
        this.contentDir = contentDir;
    }

    public abstract String getContent();

    public ContentKind getContentKind() {
        return this.contentKind;
    }

    @Nullable
    public Dir getContentDirection() {
        return this.contentDir;
    }

    @Override
    public boolean coerceToBoolean() {
        return this.getContent().length() > 0;
    }

    @Override
    public String coerceToString() {
        return this.toString();
    }

    public String toString() {
        return this.getContent();
    }

    @Override
    public String stringValue() {
        return this.getContent();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SanitizedContent && this.contentKind == ((SanitizedContent)other).contentKind && this.contentDir == ((SanitizedContent)other).contentDir && this.getContent().equals(((SanitizedContent)other).getContent());
    }

    public int hashCode() {
        return this.getContent().hashCode() + 31 * this.contentKind.hashCode();
    }

    public SafeHtml toSafeHtml() {
        Preconditions.checkState(this.getContentKind() == ContentKind.HTML, "toSafeHtml() only valid for SanitizedContent of kind HTML, is: %s", (Object)this.getContentKind());
        return UncheckedConversions.safeHtmlFromStringKnownToSatisfyTypeContract(this.getContent());
    }

    public SafeHtmlProto toSafeHtmlProto() {
        Preconditions.checkState(this.getContentKind() == ContentKind.HTML, "toSafeHtmlProto() only valid for SanitizedContent of kind HTML, is: %s", (Object)this.getContentKind());
        return SafeHtmls.toProto(UncheckedConversions.safeHtmlFromStringKnownToSatisfyTypeContract(this.getContent()));
    }

    public SafeScriptProto toSafeScriptProto() {
        Preconditions.checkState(this.getContentKind() == ContentKind.JS, "toSafeScriptProto() only valid for SanitizedContent of kind JS, is: %s", (Object)this.getContentKind());
        return SafeScripts.toProto(UncheckedConversions.safeScriptFromStringKnownToSatisfyTypeContract(this.getContent()));
    }

    public SafeStyleProto toSafeStyleProto() {
        Preconditions.checkState(this.getContentKind() == ContentKind.CSS, "toSafeStyleProto() only valid for SanitizedContent of kind CSS, is: %s", (Object)this.getContentKind());
        Preconditions.checkState(!this.getContent().contains("{"), "Calling toSafeStyleProto() with content that doesn't look like CSS declarations. Consider using toSafeStyleSheetProto().");
        return SafeStyles.toProto(UncheckedConversions.safeStyleFromStringKnownToSatisfyTypeContract(this.getContent()));
    }

    public SafeStyleSheet toSafeStyleSheet() {
        Preconditions.checkState(this.getContentKind() == ContentKind.CSS, "toSafeStyleSheet() only valid for SanitizedContent of kind CSS, is: %s", (Object)this.getContentKind());
        Preconditions.checkState(this.getContent().isEmpty() || this.getContent().indexOf(123) > 0, "Calling toSafeStyleSheet() with content that doesn't look like a stylesheet");
        return UncheckedConversions.safeStyleSheetFromStringKnownToSatisfyTypeContract(this.getContent());
    }

    public SafeStyleSheetProto toSafeStyleSheetProto() {
        Preconditions.checkState(this.getContentKind() == ContentKind.CSS, "toSafeStyleSheetProto() only valid for SanitizedContent of kind CSS, is: %s", (Object)this.getContentKind());
        return SafeStyleSheets.toProto(this.toSafeStyleSheet());
    }

    public SafeUrlProto toSafeUrlProto() {
        Preconditions.checkState(this.getContentKind() == ContentKind.URI, "toSafeUrlProto() only valid for SanitizedContent of kind URI, is: %s", (Object)this.getContentKind());
        return SafeUrls.toProto(UncheckedConversions.safeUrlFromStringKnownToSatisfyTypeContract(this.getContent()));
    }

    public TrustedResourceUrlProto toTrustedResourceUrlProto() {
        Preconditions.checkState(this.getContentKind() == ContentKind.TRUSTED_RESOURCE_URI, "toTrustedResourceUrlProto() only valid for SanitizedContent of kind TRUSTED_RESOURCE_URI, is: %s", (Object)this.getContentKind());
        return TrustedResourceUrls.toProto(UncheckedConversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract(this.getContent()));
    }

    private static final class LazyContent
    extends SanitizedContent {
        final RenderableThunk thunk;

        LazyContent(RenderableThunk thunk, ContentKind contentKind, @Nullable Dir contentDir) {
            super(contentKind, contentDir);
            this.thunk = thunk;
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            this.thunk.render(appendable);
        }

        @Override
        public String getContent() {
            return this.thunk.renderAsString();
        }
    }

    private static final class ConstantContent
    extends SanitizedContent {
        final String content;

        ConstantContent(String content, ContentKind contentKind, @Nullable Dir contentDir) {
            super(contentKind, contentDir);
            this.content = content;
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            appendable.append(this.content);
        }

        @Override
        public String getContent() {
            return this.content;
        }
    }

    public static enum ContentKind {
        HTML,
        JS,
        URI,
        TRUSTED_RESOURCE_URI,
        ATTRIBUTES,
        CSS,
        TEXT;

    }
}

