/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.html.passes;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.html.HtmlDefinitions;
import com.google.template.soy.html.IncrementalHtmlAttributeNode;
import com.google.template.soy.html.IncrementalHtmlCloseTagNode;
import com.google.template.soy.html.IncrementalHtmlOpenTagNode;
import com.google.template.soy.html.InferredElementNamespace;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class HtmlTransformVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind ENDING_STATE_MISMATCH = SoyErrorKind.of("Ending context of the content within a Soy tag must match the starting context. Transition was from {0} to {1}");
    private static final SoyErrorKind EXPECTED_ATTRIBUTE_VALUE = SoyErrorKind.of("Expected to find a quoted attribute value, but found \"{0}\".");
    private static final SoyErrorKind EXPECTED_TAG_CLOSE = SoyErrorKind.of("Expected to find the tag close character, >, but found \"{0}\".");
    private static final SoyErrorKind INVALID_SELF_CLOSING_TAG = SoyErrorKind.of("Invalid self-closing tag for \"{0}\". Self-closing tags are only valid for void tags and SVG content (partially supported). For a list of void elements, see https://www.w3.org/TR/html5/syntax.html#void-elements.");
    private static final SoyErrorKind SOY_TAG_BEFORE_ATTR_VALUE = SoyErrorKind.of("Soy statements are not allowed before an attribute value. They should be moved inside a quotation mark.");
    private static final SoyErrorKind MISSING_TAG_NAME = SoyErrorKind.of("Found a tag with an empty tag name.");
    private static final SoyErrorKind NON_STRICT_FILE = SoyErrorKind.of("The incremental HTML Soy backend requires strict autoescape mode");
    private static final SoyErrorKind NON_STRICT_TEMPLATE = SoyErrorKind.of("The incremental HTML Soy backend requires strict autoescape mode for all templates.");
    private static final SoyErrorKind UNKNOWN_CONTENT_KIND = SoyErrorKind.of("The incremental HTML Soy backend requires all let statements and parameters with content to have a content kind");
    private static final SoyErrorKind INVALID_CSS_NODE_LOCATION = SoyErrorKind.of("The incremental HTML Soy backend does not allow '{'css'}' nodes to appear in HTML outside of attribute values.");
    private static final SoyErrorKind INVALID_XID_NODE_LOCATION = SoyErrorKind.of("The incremental HTML Soy backend does not allow '{'xid'}' nodes to appear in HTML outside of attribute values.");
    private HtmlContext currentState = HtmlContext.HTML_PCDATA;
    private boolean isSelfClosingTag;
    private String currentTag = "";
    private final StringBuilder currentText = new StringBuilder();
    private String currentAttributeName = "";
    private List<SoyNode.StandaloneNode> currentAttributeValues = new ArrayList<SoyNode.StandaloneNode>();
    private SoyNode.ParentSoyNode<SoyNode.StandaloneNode> currentAttributesParent;
    private IdGenerator idGen = null;
    private final Deque<IncrementalHtmlOpenTagNode> openElementsDeque = new ArrayDeque<IncrementalHtmlOpenTagNode>();
    private final ListMultimap<RawTextNode, SoyNode.StandaloneNode> transformMapping = ArrayListMultimap.create();
    private final Set<RawTextNode> visitedRawTextNodes = new HashSet<RawTextNode>();
    private boolean suppressExpectedAttributeValueError = false;
    private final ErrorReporter errorReporter;

    public HtmlTransformVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode node) {
        super.exec(node);
        this.applyTransforms();
        return null;
    }

    private void applyTransforms() {
        for (RawTextNode node : this.visitedRawTextNodes) {
            ParentNode parent = node.getParent();
            parent.addChildren(parent.getChildIndex(node), this.transformMapping.get((Object)node));
            parent.removeChild(node);
        }
    }

    private HtmlContext getState() {
        return this.currentState;
    }

    private void setState(HtmlContext state) {
        this.currentState = state;
        this.isSelfClosingTag = false;
    }

    private void setSelfClosingTagState() {
        this.currentState = HtmlContext.HTML_TAG;
        this.isSelfClosingTag = true;
    }

    private SourceLocation deriveSourceLocation(RawTextNode node) {
        return node.getSourceLocation();
    }

    private void createTextNode(RawTextNode node) {
        Preconditions.checkState(this.getState() == HtmlContext.HTML_PCDATA);
        String currentString = this.consumeText();
        if (currentString.length() > 0) {
            SourceLocation sl = this.deriveSourceLocation(node);
            this.transformMapping.put(node, new RawTextNode(this.idGen.genId(), currentString, sl, this.getState()));
        }
    }

    private void createAttributeValueNode(RawTextNode node) {
        Preconditions.checkState(this.getState() == HtmlContext.HTML_NORMAL_ATTR_VALUE);
        String currentString = this.consumeText();
        if (currentString.length() > 0) {
            SourceLocation sl = this.deriveSourceLocation(node);
            this.currentAttributeValues.add(new RawTextNode(this.idGen.genId(), currentString, sl, this.getState()));
        }
    }

    private void createAttribute(RawTextNode node) {
        SourceLocation sl = this.deriveSourceLocation(node);
        IncrementalHtmlAttributeNode htmlAttributeNode = new IncrementalHtmlAttributeNode(this.idGen.genId(), this.currentAttributeName, sl);
        htmlAttributeNode.addChildren(this.currentAttributeValues);
        if (this.currentAttributesParent != null && !SoyTreeUtils.isDescendantOf(node, this.currentAttributesParent)) {
            this.currentAttributesParent.addChild(htmlAttributeNode);
        } else {
            this.transformMapping.put(node, htmlAttributeNode);
        }
        this.currentAttributeValues = new ArrayList<SoyNode.StandaloneNode>();
    }

    private void handleHtmlPcData(RawTextNode node, char c) {
        if (c == '<') {
            this.createTextNode(node);
            this.setState(HtmlContext.HTML_TAG_NAME);
        } else {
            this.currentText.append(c);
        }
    }

    private String consumeText() {
        String token = this.currentText.toString();
        this.currentText.setLength(0);
        return token;
    }

    private void startCapturingAttributes() {
        this.currentAttributeValues = new ArrayList<SoyNode.StandaloneNode>();
        this.setState(HtmlContext.HTML_TAG);
    }

    private void handleHtmlTagName(RawTextNode node, char c) {
        if (CharMatcher.whitespace().matches(c) || c == '>' || this.currentText.length() != 0 && c == '/') {
            SourceLocation sl;
            this.currentTag = this.consumeText();
            if (this.currentTag.length() <= 0) {
                sl = this.deriveSourceLocation(node);
                this.errorReporter.report(sl, MISSING_TAG_NAME, new Object[0]);
            }
            if (!this.currentTag.startsWith("/")) {
                sl = this.deriveSourceLocation(node);
                this.currentAttributesParent = new IncrementalHtmlOpenTagNode(this.idGen.genId(), this.currentTag, this.getNamespace(this.currentTag), sl);
            }
            if (c == '>' || c == '/') {
                this.handleHtmlTag(node, c);
            } else {
                this.startCapturingAttributes();
            }
        } else {
            this.currentText.append(c);
        }
    }

    private InferredElementNamespace getNamespace(String tagName) {
        if (tagName.equalsIgnoreCase("svg")) {
            return InferredElementNamespace.SVG;
        }
        if (tagName.equalsIgnoreCase("foreignObject") || this.openElementsDeque.isEmpty()) {
            return InferredElementNamespace.XHTML;
        }
        return this.openElementsDeque.peek().getNamespace();
    }

    private void emitHtmlOpenTagNode(String tagName, boolean isSelfClosing, RawTextNode node, SourceLocation sl) {
        InferredElementNamespace namespace = this.getNamespace(tagName);
        IncrementalHtmlOpenTagNode htmlOpenTagNode = (IncrementalHtmlOpenTagNode)this.currentAttributesParent;
        this.transformMapping.put(node, htmlOpenTagNode);
        this.openElementsDeque.push(htmlOpenTagNode);
        this.currentAttributesParent = null;
        if (!isSelfClosing) {
            return;
        }
        if (namespace == InferredElementNamespace.SVG) {
            this.emitHtmlCloseTagNode(tagName, node, sl);
        } else if (!HtmlDefinitions.HTML5_VOID_ELEMENTS.contains(this.currentTag)) {
            this.errorReporter.report(sl, INVALID_SELF_CLOSING_TAG, this.currentTag);
        }
    }

    private void emitHtmlCloseTagNode(String tagName, RawTextNode node, SourceLocation sl) {
        this.transformMapping.put(node, new IncrementalHtmlCloseTagNode(this.idGen.genId(), tagName, sl));
        boolean tagMatches = false;
        while (!this.openElementsDeque.isEmpty() && !tagMatches) {
            IncrementalHtmlOpenTagNode htmlOpenTagNode = this.openElementsDeque.pop();
            tagMatches = tagName.equalsIgnoreCase(htmlOpenTagNode.getTagName());
        }
    }

    private void handleHtmlTag(RawTextNode node, char c) {
        if (c == '>') {
            SourceLocation sl = this.deriveSourceLocation(node);
            if (this.currentTag.startsWith("/")) {
                this.emitHtmlCloseTagNode(this.currentTag.substring(1), node, sl);
            } else {
                this.emitHtmlOpenTagNode(this.currentTag, false, node, sl);
            }
            this.setState(HtmlContext.HTML_PCDATA);
        } else if (c == '/') {
            this.setSelfClosingTagState();
        } else if (!CharMatcher.whitespace().matches(c)) {
            this.setState(HtmlContext.HTML_ATTRIBUTE_NAME);
            this.currentText.append(c);
        }
    }

    private void handleHtmlSelfClosingStartTag(RawTextNode node, char c) {
        SourceLocation sl = this.deriveSourceLocation(node);
        if (c != '>') {
            this.errorReporter.report(sl, EXPECTED_TAG_CLOSE, Character.valueOf(c));
            this.setState(HtmlContext.HTML_TAG);
            this.consumeCharacter(node, c);
            return;
        }
        this.emitHtmlOpenTagNode(this.currentTag, true, node, sl);
        this.setState(HtmlContext.HTML_PCDATA);
    }

    private void handleHtmlAttributeName(RawTextNode node, char c) {
        if (c == '=') {
            this.currentAttributeName = this.consumeText();
            this.setState(HtmlContext.HTML_BEFORE_ATTRIBUTE_VALUE);
            this.suppressExpectedAttributeValueError = false;
        } else if (c == '>') {
            this.currentAttributeName = this.consumeText();
            this.createAttribute(node);
            this.handleHtmlTag(node, c);
        } else if (CharMatcher.whitespace().matches(c)) {
            this.currentAttributeName = this.consumeText();
            this.createAttribute(node);
            this.setState(HtmlContext.HTML_TAG);
        } else {
            this.currentText.append(c);
        }
    }

    private void handleHtmlBeforeAttributeValue(RawTextNode node, char c) {
        if (c == '\"') {
            this.setState(HtmlContext.HTML_NORMAL_ATTR_VALUE);
        } else if (!this.suppressExpectedAttributeValueError) {
            SourceLocation sl = this.deriveSourceLocation(node);
            this.errorReporter.report(sl, EXPECTED_ATTRIBUTE_VALUE, Character.valueOf(c));
            this.suppressExpectedAttributeValueError = true;
        }
        if (c == '>') {
            this.handleHtmlTag(node, c);
        } else if (CharMatcher.whitespace().matches(c)) {
            this.setState(HtmlContext.HTML_TAG);
        }
    }

    private void handleHtmlNormalAttrValue(RawTextNode node, char c) {
        if (c == '\"') {
            this.createAttributeValueNode(node);
            this.createAttribute(node);
            this.setState(HtmlContext.HTML_TAG);
        } else {
            this.currentText.append(c);
        }
    }

    private void consumeCharacter(RawTextNode node, char c) {
        switch (this.getState()) {
            case HTML_PCDATA: {
                this.handleHtmlPcData(node, c);
                break;
            }
            case HTML_TAG_NAME: {
                this.handleHtmlTagName(node, c);
                break;
            }
            case HTML_TAG: {
                if (this.isSelfClosingTag) {
                    this.handleHtmlSelfClosingStartTag(node, c);
                    break;
                }
                this.handleHtmlTag(node, c);
                break;
            }
            case HTML_ATTRIBUTE_NAME: {
                this.handleHtmlAttributeName(node, c);
                break;
            }
            case HTML_BEFORE_ATTRIBUTE_VALUE: {
                this.handleHtmlBeforeAttributeValue(node, c);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                this.handleHtmlNormalAttrValue(node, c);
                break;
            }
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String content = node.getRawText();
        this.visitedRawTextNodes.add(node);
        for (int i = 0; i < content.length(); ++i) {
            this.consumeCharacter(node, content.charAt(i));
        }
        switch (this.getState()) {
            case HTML_TAG_NAME: {
                this.consumeCharacter(node, ' ');
                break;
            }
            case HTML_PCDATA: {
                this.createTextNode(node);
                break;
            }
            case HTML_ATTRIBUTE_NAME: {
                this.consumeCharacter(node, ' ');
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                this.createAttributeValueNode(node);
                break;
            }
        }
    }

    private void checkForValidSoyNodeLocation(SoyNode node) {
        switch (this.getState()) {
            case HTML_BEFORE_ATTRIBUTE_VALUE: {
                this.errorReporter.report(node.getSourceLocation(), SOY_TAG_BEFORE_ATTR_VALUE, new Object[0]);
                break;
            }
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.checkForValidSoyNodeLocation(node);
        if (this.getState() == HtmlContext.HTML_NORMAL_ATTR_VALUE) {
            this.currentAttributeValues.add(node);
            node.getParent().removeChild(node);
        } else if (this.getState() == HtmlContext.HTML_TAG) {
            this.moveToCurrentAttributesParent(node);
        }
        node.setHtmlContext(this.getState());
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node) {
        this.checkForValidSoyNodeLocation(node);
        if (node.getContentKind() == null) {
            this.errorReporter.report(node.getSourceLocation(), UNKNOWN_CONTENT_KIND, new Object[0]);
        } else if (node.getContentKind() == SanitizedContent.ContentKind.HTML) {
            this.visitSoyNode(node, true);
        } else if (node.getContentKind() == SanitizedContent.ContentKind.ATTRIBUTES) {
            HtmlContext startState = this.getState();
            this.startCapturingAttributes();
            this.currentAttributesParent = node;
            this.visitChildrenAllowingConcurrentModification(node);
            this.currentAttributesParent = null;
            this.setState(startState);
        } else {
            new ContextSetterVisitor(HtmlContext.TEXT).exec(node);
        }
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitLetParamContentNode(node);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitLetParamContentNode(node);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        NamespaceDeclaration namespaceDeclaration = node.getNamespaceDeclaration();
        if (namespaceDeclaration.getDefaultAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(namespaceDeclaration.getAutoescapeModeLocation(), NON_STRICT_FILE, new Object[0]);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.idGen = node.getNodeIdGenerator();
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        switch (node.getContentKind()) {
            case HTML: {
                this.currentState = HtmlContext.HTML_PCDATA;
                break;
            }
            case ATTRIBUTES: {
                this.currentState = HtmlContext.HTML_TAG;
                this.currentAttributesParent = node;
                break;
            }
            default: {
                new ContextSetterVisitor(HtmlContext.TEXT).exec(node);
                return;
            }
        }
        if (node.getAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), NON_STRICT_TEMPLATE, new Object[0]);
        }
        this.openElementsDeque.clear();
        this.visitSoyNode(node, true);
        this.currentAttributesParent = null;
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.checkForValidSoyNodeLocation(node);
        this.visitSoyNode(node);
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitSwitchCaseNode(SwitchCaseNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitSwitchDefaultNode(SwitchDefaultNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitLoopNode(SoyNode.LoopNode node) {
        this.visitSoyNode(node, true);
    }

    @Override
    protected void visitCssNode(CssNode node) {
        if (this.getState() != HtmlContext.HTML_NORMAL_ATTR_VALUE) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_CSS_NODE_LOCATION, new Object[0]);
        }
        this.visitSoyNode(node);
    }

    @Override
    protected void visitXidNode(XidNode node) {
        if (this.getState() != HtmlContext.HTML_NORMAL_ATTR_VALUE) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_XID_NODE_LOCATION, new Object[0]);
        }
        this.visitSoyNode(node);
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        node.setHtmlContext(this.getState());
        this.visitSoyNode(node);
    }

    @Override
    protected void visitLogNode(LogNode node) {
        new ContextSetterVisitor(HtmlContext.TEXT).exec(node);
    }

    private void visitSoyNode(SoyNode node, boolean enforceState) {
        switch (this.getState()) {
            case HTML_BEFORE_ATTRIBUTE_VALUE: {
                this.errorReporter.report(node.getSourceLocation(), SOY_TAG_BEFORE_ATTR_VALUE, new Object[0]);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                if (!(node instanceof SoyNode.StandaloneNode)) break;
                SoyNode.StandaloneNode standaloneNode = (SoyNode.StandaloneNode)node;
                standaloneNode.getParent().removeChild(standaloneNode);
                this.currentAttributeValues.add(standaloneNode);
                new ContextSetterVisitor(this.getState()){

                    @Override
                    protected void visitCallParamContentNode(CallParamContentNode node) {
                        new ContextSetterVisitor(HtmlContext.TEXT).exec(node);
                    }
                }.exec(node);
                break;
            }
            case HTML_TAG: {
                this.moveToCurrentAttributesParent(node);
                this.visitChildrenAndCheckState(node, enforceState);
                break;
            }
            case HTML_PCDATA: {
                this.visitChildrenAndCheckState(node, enforceState);
                break;
            }
        }
    }

    private void visitChildrenAndCheckState(SoyNode node, boolean enforceState) {
        if (node instanceof SoyNode.ParentSoyNode) {
            HtmlContext startState = this.getState();
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
            HtmlContext endState = this.getState();
            if (enforceState && startState != endState) {
                this.errorReporter.report(node.getSourceLocation(), ENDING_STATE_MISMATCH, new Object[]{startState, endState});
            }
            this.consumeText();
        }
    }

    private void moveToCurrentAttributesParent(SoyNode node) {
        if (this.currentAttributesParent != null && !SoyTreeUtils.isDescendantOf(node, this.currentAttributesParent) && node instanceof SoyNode.StandaloneNode) {
            SoyNode.StandaloneNode standaloneNode = (SoyNode.StandaloneNode)node;
            standaloneNode.getParent().removeChild(standaloneNode);
            this.currentAttributesParent.addChild(standaloneNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.visitSoyNode(node, false);
    }

    private static class ContextSetterVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private final HtmlContext value;

        ContextSetterVisitor(HtmlContext value) {
            this.value = value;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            node.setHtmlContext(this.value);
            this.visitChildren(node);
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            node.setHtmlContext(this.value);
        }

        @Override
        protected void visitRawTextNode(RawTextNode node) {
            node.setHtmlContext(this.value);
        }
    }
}

