/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_MapLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
abstract class MapLiteral
extends CodeChunk.WithValue {
    MapLiteral() {
    }

    abstract ImmutableList<? extends CodeChunk.WithValue> keys();

    abstract ImmutableList<? extends CodeChunk.WithValue> values();

    static MapLiteral create(ImmutableList<? extends CodeChunk.WithValue> keys, ImmutableList<? extends CodeChunk.WithValue> values) {
        Preconditions.checkArgument(keys.size() == values.size(), "Mismatch between keys and values.");
        ImmutableSet.Builder initialStatements = ImmutableSet.builder();
        for (CodeChunk.WithValue withValue : keys) {
            initialStatements.addAll(withValue.initialStatements());
        }
        for (CodeChunk.WithValue withValue : values) {
            initialStatements.addAll(withValue.initialStatements());
        }
        return new AutoValue_MapLiteral((ImmutableSet<CodeChunk>)initialStatements.build(), keys, values);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('{');
        for (int i = 0; i < this.keys().size(); ++i) {
            if (i > 0) {
                ctx.append(", ");
            }
            ctx.appendOutputExpression((CodeChunk.WithValue)this.keys().get(i)).append(": ").appendOutputExpression((CodeChunk.WithValue)this.values().get(i));
        }
        ctx.append('}');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk.WithValue withValue : this.keys()) {
            ctx.appendInitialStatements(withValue);
        }
        for (CodeChunk.WithValue withValue : this.values()) {
            ctx.appendInitialStatements(withValue);
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue withValue : this.keys()) {
            withValue.collectRequires(collector);
        }
        for (CodeChunk.WithValue withValue : this.values()) {
            withValue.collectRequires(collector);
        }
    }
}

