/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import java.util.List;

public final class SoyJsPluginUtils {
    private static final Function<CodeChunk.WithValue, JsExpr> TO_JS_EXPR = new Function<CodeChunk.WithValue, JsExpr>(){

        @Override
        public JsExpr apply(CodeChunk.WithValue chunk) {
            return chunk.singleExprOrName();
        }
    };

    private SoyJsPluginUtils() {
    }

    public static JsExpr genJsExprUsingSoySyntax(Operator op, List<JsExpr> operandJsExprs) {
        List<CodeChunk.WithValue> operands = Lists.transform(operandJsExprs, new Function<JsExpr, CodeChunk.WithValue>(){

            @Override
            public CodeChunk.WithValue apply(JsExpr input) {
                return CodeChunk.fromExpr(input, ImmutableList.of());
            }
        });
        return CodeChunk.operation(op, operands).assertExpr();
    }

    public static CodeChunk.WithValue applyDirective(CodeChunk.Generator generator, CodeChunk.WithValue expr, SoyJsSrcPrintDirective directive, List<CodeChunk.WithValue> args) {
        List<JsExpr> argExprs = Lists.transform(args, TO_JS_EXPR);
        JsExpr applied = directive.applyForJsSrc(expr.singleExprOrName(), argExprs);
        CodeChunk.RequiresCollector.IntoImmutableSet collector = new CodeChunk.RequiresCollector.IntoImmutableSet();
        expr.collectRequires(collector);
        for (CodeChunk.WithValue arg : args) {
            arg.collectRequires(collector);
        }
        if (directive instanceof SoyLibraryAssistedJsSrcPrintDirective) {
            for (String name : ((SoyLibraryAssistedJsSrcPrintDirective)directive).getRequiredJsLibNames()) {
                collector.add(GoogRequire.create(name));
            }
        }
        ImmutableCollection.Builder initialStatements = ImmutableList.builder().addAll(expr.initialStatements());
        for (CodeChunk.WithValue arg : args) {
            ((ImmutableList.Builder)initialStatements).addAll(arg.initialStatements());
        }
        return CodeChunk.fromExpr(applied, collector.get()).withInitialStatements(((ImmutableList.Builder)initialStatements).build());
    }
}

