/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.MsgFuncGenerator;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.XidNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenPyExprsVisitor
extends AbstractSoyNodeVisitor<List<PyExpr>> {
    private Map<String, SoyPySrcPrintDirective> soyPySrcDirectivesMap;
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    private final GenPyCallExprVisitor genPyCallExprVisitor;
    private final MsgFuncGenerator.MsgFuncGeneratorFactory msgFuncGeneratorFactory;
    private final LocalVariableStack localVarExprs;
    private List<PyExpr> pyExprs;
    private final ErrorReporter errorReporter;

    @AssistedInject
    GenPyExprsVisitor(ImmutableMap<String, SoyPySrcPrintDirective> soyPySrcDirectivesMap, IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, GenPyExprsVisitorFactory genPyExprsVisitorFactory, MsgFuncGenerator.MsgFuncGeneratorFactory msgFuncGeneratorFactory, GenPyCallExprVisitor genPyCallExprVisitor, @Assisted LocalVariableStack localVarExprs, @Assisted ErrorReporter errorReporter) {
        this.soyPySrcDirectivesMap = soyPySrcDirectivesMap;
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
        this.genPyCallExprVisitor = genPyCallExprVisitor;
        this.msgFuncGeneratorFactory = msgFuncGeneratorFactory;
        this.localVarExprs = localVarExprs;
        this.errorReporter = errorReporter;
    }

    @Override
    public List<PyExpr> exec(SoyNode node) {
        Preconditions.checkArgument((Boolean)this.isComputableAsPyExprVisitor.exec(node));
        this.pyExprs = new ArrayList<PyExpr>();
        this.visit(node);
        return this.pyExprs;
    }

    List<PyExpr> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument(this.isComputableAsPyExprVisitor.execOnChildren(node));
        this.pyExprs = new ArrayList<PyExpr>();
        this.visitChildren(node);
        return this.pyExprs;
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String exprText = BaseUtils.escapeToSoyString(node.getRawText(), false);
        this.pyExprs.add(new PyStringExpr(exprText));
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarExprs, this.errorReporter);
        PyExpr pyExpr = (PyExpr)translator.exec(node.getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyPySrcPrintDirective directive = this.soyPySrcDirectivesMap.get(directiveNode.getName());
            if (directive == null) {
                throw LegacyInternalSyntaxException.createWithMetaInfo("Failed to find SoyPySrcPrintDirective with name '" + directiveNode.getName() + "'" + " (tag " + node.toSourceString() + ")", directiveNode.getSourceLocation());
            }
            List<ExprRootNode> args = directiveNode.getArgs();
            if (!directive.getValidArgsSizes().contains(args.size())) {
                throw LegacyInternalSyntaxException.createWithMetaInfo("Print directive '" + directiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + node.toSourceString() + ").", directiveNode.getSourceLocation());
            }
            ArrayList<PyExpr> argsPyExprs = new ArrayList<PyExpr>(args.size());
            for (ExprRootNode arg : args) {
                argsPyExprs.add((PyExpr)translator.exec(arg));
            }
            pyExpr = directive.applyForPySrc(pyExpr, argsPyExprs);
        }
        this.pyExprs.add(pyExpr);
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        PyExpr msg = this.msgFuncGeneratorFactory.create(node.getMsg(), this.localVarExprs, this.errorReporter).getPyExpr();
        if (node.hasFallbackMsg()) {
            StringBuilder pyExprTextSb = new StringBuilder();
            PyStringExpr fallbackMsg = this.msgFuncGeneratorFactory.create(node.getFallbackMsg(), this.localVarExprs, this.errorReporter).getPyExpr();
            pyExprTextSb.append(msg.getText()).append(" if ");
            long firstId = MsgUtils.computeMsgIdForDualFormat(node.getMsg());
            long secondId = MsgUtils.computeMsgIdForDualFormat(node.getFallbackMsg());
            pyExprTextSb.append("translator_impl").append(".is_msg_available(").append(firstId).append(")").append(" or not ").append("translator_impl").append(".is_msg_available(").append(secondId).append(")");
            pyExprTextSb.append(" else ").append(fallbackMsg.getText());
            msg = new PyStringExpr(pyExprTextSb.toString(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
        }
        for (String directiveName : node.getEscapingDirectiveNames()) {
            SoyPySrcPrintDirective directive = this.soyPySrcDirectivesMap.get(directiveName);
            Preconditions.checkNotNull(directive, "Contextual autoescaping produced a bogus directive: %s", (Object)directiveName);
            msg = directive.applyForPySrc(msg, ImmutableList.of());
        }
        this.pyExprs.add(msg);
    }

    @Override
    protected void visitXidNode(XidNode node) {
        StringBuilder sb = new StringBuilder("runtime.get_xid_name('").append(node.getText()).append("')");
        this.pyExprs.add(new PyExpr(sb.toString(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitCssNode(CssNode node) {
        StringBuilder sb = new StringBuilder("runtime.get_css_name(");
        ExprRootNode componentNameExpr = node.getComponentNameExpr();
        if (componentNameExpr != null) {
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarExprs, this.errorReporter);
            PyExpr basePyExpr = (PyExpr)translator.exec(componentNameExpr);
            sb.append(basePyExpr.getText()).append(", ");
        }
        sb.append("'").append(node.getSelectorText()).append("')");
        this.pyExprs.add(new PyExpr(sb.toString(), Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenPyExprsVisitor genPyExprsVisitor = this.genPyExprsVisitorFactory.create(this.localVarExprs, this.errorReporter);
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarExprs, this.errorReporter);
        StringBuilder pyExprTextSb = new StringBuilder();
        boolean hasElse = false;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                PyExpr condBlock = PyExprUtils.concatPyExprs(genPyExprsVisitor.exec(icn)).toPyString();
                condBlock = PyExprUtils.maybeProtect(condBlock, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
                pyExprTextSb.append(condBlock.getText());
                PyExpr condPyExpr = (PyExpr)translator.exec(icn.getExpr());
                pyExprTextSb.append(" if ").append(condPyExpr.getText()).append(" else ");
                continue;
            }
            if (child instanceof IfElseNode) {
                hasElse = true;
                IfElseNode ien = (IfElseNode)child;
                PyStringExpr elseBlock = PyExprUtils.concatPyExprs(genPyExprsVisitor.exec(ien)).toPyString();
                pyExprTextSb.append(elseBlock.getText());
                continue;
            }
            throw new AssertionError((Object)("Unexpected if child node type. Child: " + child));
        }
        if (!hasElse) {
            pyExprTextSb.append("''");
        }
        this.pyExprs.add(new PyStringExpr(pyExprTextSb.toString(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL)));
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.pyExprs.add(this.genPyCallExprVisitor.exec(node, this.localVarExprs, this.errorReporter));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static interface GenPyExprsVisitorFactory {
        public GenPyExprsVisitor create(LocalVariableStack var1, ErrorReporter var2);
    }
}

