/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.CustomDefaultLabelMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public class OneOrMoreMatcher
extends CustomDefaultLabelMatcher<OneOrMoreMatcher> {
    public final Matcher subMatcher = (Matcher)this.getChildren().get(0);

    public OneOrMoreMatcher(Rule subRule) {
        super(Preconditions.checkNotNull(subRule, "subRule"), "oneOrMore");
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        boolean matched = this.subMatcher.getSubContext(context).runMatcher();
        if (!matched) {
            return false;
        }
        int beforeMatch = context.getCurrentIndex();
        while (this.subMatcher.getSubContext(context).runMatcher()) {
            int afterMatch = context.getCurrentIndex();
            if (afterMatch != beforeMatch) {
                beforeMatch = afterMatch;
                continue;
            }
            throw new GrammarException("The inner rule of OneOrMore rule '%s' must not allow empty matches", context.getPath());
        }
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

