/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.Node;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.ParseError;
import org.parboiled.support.ValueStack;

public class ParsingResult<V> {
    public final boolean matched;
    public final Node<V> parseTreeRoot;
    public final V resultValue;
    public final ValueStack<V> valueStack;
    public final List<ParseError> parseErrors;
    public final InputBuffer inputBuffer;

    public ParsingResult(boolean matched, Node<V> parseTreeRoot, @Nonnull ValueStack<V> valueStack, @Nonnull List<ParseError> parseErrors, @Nonnull InputBuffer inputBuffer) {
        this.matched = matched;
        this.parseTreeRoot = parseTreeRoot;
        this.valueStack = Preconditions.checkNotNull(valueStack);
        this.resultValue = valueStack.isEmpty() ? null : valueStack.peek();
        this.parseErrors = Preconditions.checkNotNull(parseErrors);
        this.inputBuffer = Preconditions.checkNotNull(inputBuffer);
    }

    public final boolean isSuccess() {
        return this.matched;
    }

    @Nullable
    public final Node<V> getParseTree() {
        return this.parseTreeRoot;
    }

    @Nullable
    public final V getTopStackValue() {
        return this.resultValue;
    }

    @Nonnull
    public final ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    @Nonnull
    public final List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    @Nonnull
    public final InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public final boolean hasCollectedParseErrors() {
        return !this.parseErrors.isEmpty();
    }

    @Deprecated
    public boolean hasErrors() {
        return this.hasCollectedParseErrors();
    }
}

