/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.github.parboiled1.grappa.transform.asm.LoadingOpcode;
import com.github.parboiled1.grappa.transform.cache.ClassCache;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.BaseParser;
import org.parboiled.ContextAware;
import org.parboiled.support.Var;

public final class AsmUtils {
    private static final ClassCache CACHE = ClassCache.INSTANCE;
    private static final Map<String, Class<?>> classForDesc = new HashMap();

    private AsmUtils() {
    }

    @Deprecated
    public static ClassReader createClassReader(Class<?> c) throws IOException {
        Preconditions.checkNotNull(c);
        String classFilename = c.getName().replace('.', '/') + ".class";
        InputStream inputStream = c.getClassLoader().getResourceAsStream(classFilename);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classFilename);
        }
        return new ClassReader(inputStream);
    }

    public static String getExtendedParserClassName(String parserClassName) {
        Preconditions.checkNotNull(parserClassName, "parserClassName");
        return parserClassName + "$$parboiled";
    }

    @Deprecated
    public static synchronized Class<?> getClassForInternalName(String classDesc) {
        Preconditions.checkNotNull(classDesc, "classDesc");
        Class<?> c = classForDesc.get(classDesc);
        if (c != null) {
            return c;
        }
        if (classDesc.charAt(0) == '[') {
            Class<?> compType = AsmUtils.getClassForType(Type.getType(classDesc.substring(1)));
            c = Array.newInstance(compType, 0).getClass();
        } else {
            String className = classDesc.replace('/', '.');
            try {
                c = AsmUtils.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ignored) {
                try {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class '" + className + "' for rule method analysis", e);
                }
            }
        }
        classForDesc.put(classDesc, c);
        return c;
    }

    public static Class<?> getClassForType(Type type) {
        Preconditions.checkNotNull(type, "type");
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: 
            case 10: {
                return CACHE.loadClass(type.getInternalName());
            }
        }
        throw new IllegalStateException();
    }

    public static Field getClassField(String classInternalName, String fieldName) {
        Class<?> c;
        Preconditions.checkNotNull(classInternalName, "classInternalName");
        Preconditions.checkNotNull(fieldName, "fieldName");
        for (Class<?> current = c = CACHE.loadClass(classInternalName); current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        throw new RuntimeException("Field '" + fieldName + "' not found in '" + c.getCanonicalName() + "' or any superclass");
    }

    public static Method getClassMethod(String classInternalName, String methodName, String methodDesc) {
        Preconditions.checkNotNull(classInternalName, "classInternalName");
        Preconditions.checkNotNull(methodName, "methodName");
        Preconditions.checkNotNull(methodDesc, "methodDesc");
        Class<?> c = CACHE.loadClass(classInternalName);
        Type[] types = Type.getArgumentTypes(methodDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        Method method = AsmUtils.findMethod(c, methodName, argTypes);
        if (method == null) {
            throw new RuntimeException("Method '" + methodName + "' with descriptor '" + methodDesc + "' not found in '" + c + "' or any supertype");
        }
        return method;
    }

    @Nullable
    private static Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ignored) {
            Method ret = AsmUtils.findMethod(clazz.getSuperclass(), methodName, argTypes);
            if (ret != null) {
                return ret;
            }
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                ret = AsmUtils.findMethod(interfaceClass, methodName, argTypes);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
    }

    public static Constructor<?> getClassConstructor(String classInternalName, String constructorDesc) {
        Preconditions.checkNotNull(classInternalName, "classInternalName");
        Preconditions.checkNotNull(constructorDesc, "constructorDesc");
        Class<?> c = CACHE.loadClass(classInternalName);
        Type[] types = Type.getArgumentTypes(constructorDesc);
        Class[] argTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            argTypes[i] = AsmUtils.getClassForType(types[i]);
        }
        try {
            return c.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Constructor with descriptor '" + constructorDesc + "' not found in '" + c, e);
        }
    }

    @Nullable
    public static Class<?> findLoadedClass(String className, ClassLoader classLoader) {
        Method m;
        Class<?> c;
        Preconditions.checkNotNull(className, "className");
        Preconditions.checkNotNull(classLoader, "classLoader");
        try {
            c = Class.forName("java.lang.ClassLoader");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        try {
            m = c.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        m.setAccessible(true);
        try {
            Class e = (Class)m.invoke((Object)classLoader, className);
            return e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not determine whether class '" + className + "' has already been loaded", e);
        }
        finally {
            m.setAccessible(false);
        }
    }

    public static Class<?> loadClass(String className, byte[] code, ClassLoader classLoader) {
        Method m;
        Class<?> c;
        Preconditions.checkNotNull(className, "className");
        Preconditions.checkNotNull(code, "code");
        Preconditions.checkNotNull(classLoader, "classLoader");
        try {
            c = Class.forName("java.lang.ClassLoader");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        try {
            m = c.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        m.setAccessible(true);
        try {
            Class e = (Class)m.invoke((Object)classLoader, className, code, 0, code.length);
            return e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not load class '" + className + '\'', e);
        }
        finally {
            m.setAccessible(false);
        }
    }

    public static InsnList createArgumentLoaders(String methodDescriptor) {
        Preconditions.checkNotNull(methodDescriptor, "methodDescriptor");
        InsnList instructions = new InsnList();
        Type[] types = Type.getArgumentTypes(methodDescriptor);
        for (int i = 0; i < types.length; ++i) {
            int opcode = LoadingOpcode.forType(types[i]);
            VarInsnNode node = new VarInsnNode(opcode, i + 1);
            instructions.add(node);
        }
        return instructions;
    }

    @Deprecated
    public static int getLoadingOpcode(Type argType) {
        Preconditions.checkNotNull(argType, "argType");
        switch (argType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 8: {
                return 24;
            }
            case 6: {
                return 23;
            }
            case 7: {
                return 22;
            }
            case 9: 
            case 10: {
                return 25;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isAssignableTo(String classInternalName, Class<?> type) {
        Preconditions.checkNotNull(classInternalName, "classInternalName");
        Preconditions.checkNotNull(type, "type");
        Class<?> c = CACHE.loadClass(classInternalName);
        return type.isAssignableFrom(c);
    }

    public static boolean isBooleanValueOfZ(AbstractInsnNode insn) {
        Preconditions.checkNotNull(insn, "insn");
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isBooleanValueOfZ(mi.owner, mi.name, mi.desc);
    }

    public static boolean isBooleanValueOfZ(String methodOwner, String methodName, String methodDesc) {
        Preconditions.checkNotNull(methodOwner, "methodOwner");
        Preconditions.checkNotNull(methodName, "methodName");
        Preconditions.checkNotNull(methodDesc, "methodDesc");
        return CodegenUtils.p(Boolean.class).equals(methodOwner) && "valueOf".equals(methodName) && CodegenUtils.sig(Boolean.class, Boolean.TYPE).equals(methodDesc);
    }

    public static boolean isActionRoot(AbstractInsnNode insn) {
        Preconditions.checkNotNull(insn, "insn");
        if (insn.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isActionRoot(mi.owner, mi.name);
    }

    public static boolean isActionRoot(String methodOwner, String methodName) {
        Preconditions.checkNotNull(methodOwner, "methodOwner");
        Preconditions.checkNotNull(methodName, "methodName");
        return "ACTION".equals(methodName) && AsmUtils.isAssignableTo(methodOwner, BaseParser.class);
    }

    public static boolean isVarRoot(AbstractInsnNode insn) {
        Preconditions.checkNotNull(insn, "insn");
        if (insn.getOpcode() != 183) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isVarRoot(mi.owner, mi.name, mi.desc);
    }

    public static boolean isVarRoot(String methodOwner, String methodName, String methodDesc) {
        Preconditions.checkNotNull(methodOwner, "methodOwner");
        Preconditions.checkNotNull(methodName, "methodName");
        Preconditions.checkNotNull(methodDesc, "methodDesc");
        return "<init>".equals(methodName) && CodegenUtils.sig(Void.TYPE, Object.class).equals(methodDesc) && AsmUtils.isAssignableTo(methodOwner, Var.class);
    }

    public static boolean isCallOnContextAware(AbstractInsnNode insn) {
        Preconditions.checkNotNull(insn, "insn");
        if (insn.getOpcode() != 182 && insn.getOpcode() != 185) {
            return false;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        return AsmUtils.isAssignableTo(mi.owner, ContextAware.class);
    }
}

