/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.trie;

import com.github.parboiled1.grappa.matchers.trie.TrieNode;
import com.google.common.annotations.Beta;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.TreeMap;

@Beta
public final class TrieNodeBuilder {
    private boolean fullWord = false;
    private final Map<Character, TrieNodeBuilder> subnodes = new TreeMap<Character, TrieNodeBuilder>();

    TrieNodeBuilder addWord(String word) {
        this.doAddWord(CharBuffer.wrap(word));
        return this;
    }

    private void doAddWord(CharBuffer buffer) {
        if (!buffer.hasRemaining()) {
            this.fullWord = true;
            return;
        }
        char c = buffer.get();
        TrieNodeBuilder builder = this.subnodes.get(Character.valueOf(c));
        if (builder == null) {
            builder = new TrieNodeBuilder();
            this.subnodes.put(Character.valueOf(c), builder);
        }
        builder.doAddWord(buffer);
    }

    public TrieNode build() {
        char[] nextChars = new char[this.subnodes.size()];
        TrieNode[] nextNodes = new TrieNode[this.subnodes.size()];
        int index = 0;
        for (Map.Entry<Character, TrieNodeBuilder> entry : this.subnodes.entrySet()) {
            nextChars[index] = entry.getKey().charValue();
            nextNodes[index] = entry.getValue().build();
            ++index;
        }
        return new TrieNode(this.fullWord, nextChars, nextNodes);
    }
}

