/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.errorprone.annotations.CompileTimeConstant;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class TrustedResourceUrls {
    private TrustedResourceUrls() {
    }

    public static TrustedResourceUrl fromProto(TrustedResourceUrlProto proto) {
        return TrustedResourceUrls.create(proto.getPrivateDoNotAccessOrElseTrustedResourceUrlWrappedValue());
    }

    public static TrustedResourceUrlProto toProto(TrustedResourceUrl url) {
        return TrustedResourceUrlProto.newBuilder().setPrivateDoNotAccessOrElseTrustedResourceUrlWrappedValue(url.getTrustedResourceUrlString()).build();
    }

    public static TrustedResourceUrl fromConstant(@CompileTimeConstant String url) {
        return TrustedResourceUrls.create(url);
    }

    @Nullable
    @GwtIncompatible(value="System.getEnv")
    public static TrustedResourceUrl fromEnvironmentVariable(@CompileTimeConstant String variableName) {
        String var = System.getenv(variableName);
        if (var == null) {
            return null;
        }
        return TrustedResourceUrls.create(var);
    }

    static TrustedResourceUrl create(String url) {
        return new TrustedResourceUrl(url);
    }
}

