/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelFunction;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LabelType {
    public static final boolean DEF_ALLOW_POST_SUBMIT = true;
    public static final boolean DEF_CAN_OVERRIDE = true;
    public static final boolean DEF_COPY_ALL_SCORES_IF_NO_CHANGE = true;
    public static final boolean DEF_COPY_ALL_SCORES_IF_NO_CODE_CHANGE = false;
    public static final boolean DEF_COPY_ALL_SCORES_ON_TRIVIAL_REBASE = false;
    public static final boolean DEF_COPY_ALL_SCORES_ON_MERGE_FIRST_PARENT_UPDATE = false;
    public static final boolean DEF_COPY_MAX_SCORE = false;
    public static final boolean DEF_COPY_MIN_SCORE = false;
    protected String name;
    protected String functionName;
    protected boolean copyMinScore;
    protected boolean copyMaxScore;
    protected boolean copyAllScoresOnMergeFirstParentUpdate;
    protected boolean copyAllScoresOnTrivialRebase;
    protected boolean copyAllScoresIfNoCodeChange;
    protected boolean copyAllScoresIfNoChange;
    protected boolean allowPostSubmit;
    protected short defaultValue;
    protected List<LabelValue> values;
    protected short maxNegative;
    protected short maxPositive;
    private transient boolean canOverride;
    private transient List<String> refPatterns;
    private transient List<Integer> intList;
    private transient Map<Short, LabelValue> byValue;

    public static LabelType withDefaultValues(String name) {
        LabelType.checkName(name);
        ArrayList<LabelValue> values = new ArrayList<LabelValue>(2);
        values.add(new LabelValue(0, "Rejected"));
        values.add(new LabelValue(1, "Approved"));
        return new LabelType(name, values);
    }

    public static String checkName(String name) {
        LabelType.checkNameInternal(name);
        if ("SUBM".equals(name)) {
            throw new IllegalArgumentException("Reserved label name \"" + name + "\"");
        }
        return name;
    }

    public static String checkNameInternal(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty label name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ((i != 0 || c != '-') && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-')) continue;
            throw new IllegalArgumentException("Illegal label name \"" + name + "\"");
        }
        return name;
    }

    private static List<LabelValue> sortValues(List<LabelValue> values) {
        if ((values = new ArrayList<LabelValue>(values)).size() <= 1) {
            return Collections.unmodifiableList(values);
        }
        Collections.sort(values, new Comparator<LabelValue>(){

            @Override
            public int compare(LabelValue o1, LabelValue o2) {
                return o1.getValue() - o2.getValue();
            }
        });
        short min = values.get(0).getValue();
        short max = values.get(values.size() - 1).getValue();
        short v = min;
        ArrayList<LabelValue> result = new ArrayList<LabelValue>(max - min + 1);
        for (int i = 0; i < values.size(); i = (int)((short)(i + 1))) {
            while (v < values.get(i).getValue()) {
                short s = v;
                v = (short)(v + 1);
                result.add(new LabelValue(s, ""));
            }
            v = (short)(v + 1);
            int n = i;
            result.add(values.get(n));
        }
        return Collections.unmodifiableList(result);
    }

    protected LabelType() {
    }

    public LabelType(String name, List<LabelValue> valueList) {
        this.name = LabelType.checkName(name);
        this.canOverride = true;
        this.values = LabelType.sortValues(valueList);
        this.defaultValue = 0;
        this.functionName = LabelFunction.MAX_WITH_BLOCK.getFunctionName();
        this.maxNegative = Short.MIN_VALUE;
        this.maxPositive = Short.MAX_VALUE;
        if (this.values.size() > 0) {
            if (this.values.get(0).getValue() < 0) {
                this.maxNegative = this.values.get(0).getValue();
            }
            if (this.values.get(this.values.size() - 1).getValue() > 0) {
                this.maxPositive = this.values.get(this.values.size() - 1).getValue();
            }
        }
        this.setCanOverride(true);
        this.setCopyAllScoresIfNoChange(true);
        this.setCopyAllScoresIfNoCodeChange(false);
        this.setCopyAllScoresOnTrivialRebase(false);
        this.setCopyAllScoresOnMergeFirstParentUpdate(false);
        this.setCopyMaxScore(false);
        this.setCopyMinScore(false);
        this.setAllowPostSubmit(true);
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(PatchSetApproval psa) {
        return psa.getLabelId().get().equalsIgnoreCase(this.name);
    }

    public LabelFunction getFunction() {
        if (this.functionName == null) {
            return null;
        }
        Optional<LabelFunction> f = LabelFunction.parse(this.functionName);
        if (!f.isPresent()) {
            throw new IllegalStateException("Unsupported functionName: " + this.functionName);
        }
        return f.get();
    }

    public void setFunction(@Nullable LabelFunction function) {
        this.functionName = function != null ? function.getFunctionName() : null;
    }

    public boolean canOverride() {
        return this.canOverride;
    }

    public List<String> getRefPatterns() {
        return this.refPatterns;
    }

    public void setCanOverride(boolean canOverride) {
        this.canOverride = canOverride;
    }

    public boolean allowPostSubmit() {
        return this.allowPostSubmit;
    }

    public void setAllowPostSubmit(boolean allowPostSubmit) {
        this.allowPostSubmit = allowPostSubmit;
    }

    public void setRefPatterns(List<String> refPatterns) {
        this.refPatterns = refPatterns;
    }

    public List<LabelValue> getValues() {
        return this.values;
    }

    public LabelValue getMin() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public LabelValue getMax() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(this.values.size() - 1);
    }

    public short getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(short defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isCopyMinScore() {
        return this.copyMinScore;
    }

    public void setCopyMinScore(boolean copyMinScore) {
        this.copyMinScore = copyMinScore;
    }

    public boolean isCopyMaxScore() {
        return this.copyMaxScore;
    }

    public void setCopyMaxScore(boolean copyMaxScore) {
        this.copyMaxScore = copyMaxScore;
    }

    public boolean isCopyAllScoresOnMergeFirstParentUpdate() {
        return this.copyAllScoresOnMergeFirstParentUpdate;
    }

    public void setCopyAllScoresOnMergeFirstParentUpdate(boolean copyAllScoresOnMergeFirstParentUpdate) {
        this.copyAllScoresOnMergeFirstParentUpdate = copyAllScoresOnMergeFirstParentUpdate;
    }

    public boolean isCopyAllScoresOnTrivialRebase() {
        return this.copyAllScoresOnTrivialRebase;
    }

    public void setCopyAllScoresOnTrivialRebase(boolean copyAllScoresOnTrivialRebase) {
        this.copyAllScoresOnTrivialRebase = copyAllScoresOnTrivialRebase;
    }

    public boolean isCopyAllScoresIfNoCodeChange() {
        return this.copyAllScoresIfNoCodeChange;
    }

    public void setCopyAllScoresIfNoCodeChange(boolean copyAllScoresIfNoCodeChange) {
        this.copyAllScoresIfNoCodeChange = copyAllScoresIfNoCodeChange;
    }

    public boolean isCopyAllScoresIfNoChange() {
        return this.copyAllScoresIfNoChange;
    }

    public void setCopyAllScoresIfNoChange(boolean copyAllScoresIfNoChange) {
        this.copyAllScoresIfNoChange = copyAllScoresIfNoChange;
    }

    public boolean isMaxNegative(PatchSetApproval ca) {
        return this.maxNegative == ca.getValue();
    }

    public boolean isMaxPositive(PatchSetApproval ca) {
        return this.maxPositive == ca.getValue();
    }

    public LabelValue getValue(short value) {
        this.initByValue();
        return this.byValue.get(value);
    }

    public LabelValue getValue(PatchSetApproval ca) {
        this.initByValue();
        return this.byValue.get(ca.getValue());
    }

    private void initByValue() {
        if (this.byValue == null) {
            this.byValue = new HashMap<Short, LabelValue>();
            for (LabelValue v : this.values) {
                this.byValue.put(v.getValue(), v);
            }
        }
    }

    public List<Integer> getValuesAsList() {
        if (this.intList == null) {
            this.intList = new ArrayList<Integer>(this.values.size());
            for (LabelValue v : this.values) {
                this.intList.add(Integer.valueOf(v.getValue()));
            }
            Collections.sort(this.intList);
            Collections.reverse(this.intList);
        }
        return this.intList;
    }

    public LabelId getLabelId() {
        return new LabelId(this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name).append('[');
        LabelValue min = this.getMin();
        LabelValue max = this.getMax();
        if (min != null && max != null) {
            sb.append(new PermissionRange(Permission.forLabel(this.name), min.getValue(), max.getValue()).toString().trim());
        } else if (min != null) {
            sb.append(min.formatValue().trim());
        } else if (max != null) {
            sb.append(max.formatValue().trim());
        }
        sb.append(']');
        return sb.toString();
    }
}

