/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.inject.Key;
import com.google.inject.Provider;

public class PrivateInternals_DynamicMapImpl<T>
extends DynamicMap<T> {
    PrivateInternals_DynamicMapImpl() {
    }

    public RegistrationHandle put(String pluginName, String exportName, final Provider<T> item) {
        final DynamicMap.NamePair key = new DynamicMap.NamePair(pluginName, exportName);
        this.items.put(key, item);
        return new RegistrationHandle(){

            @Override
            public void remove() {
                PrivateInternals_DynamicMapImpl.this.items.remove(key, item);
            }
        };
    }

    public ReloadableRegistrationHandle<T> put(String pluginName, Key<T> key, Provider<T> item) {
        String exportName = ((Export)key.getAnnotation()).value();
        DynamicMap.NamePair np = new DynamicMap.NamePair(pluginName, exportName);
        this.items.put(np, item);
        return new ReloadableHandle(np, key, item);
    }

    private class ReloadableHandle
    implements ReloadableRegistrationHandle<T> {
        private final DynamicMap.NamePair np;
        private final Key<T> key;
        private final Provider<T> item;

        ReloadableHandle(DynamicMap.NamePair np, Key<T> key, Provider<T> item) {
            this.np = np;
            this.key = key;
            this.item = item;
        }

        @Override
        public void remove() {
            PrivateInternals_DynamicMapImpl.this.items.remove(this.np, this.item);
        }

        @Override
        public Key<T> getKey() {
            return this.key;
        }

        @Override
        public ReloadableHandle replace(Key<T> newKey, Provider<T> newItem) {
            if (PrivateInternals_DynamicMapImpl.this.items.replace(this.np, this.item, newItem)) {
                return new ReloadableHandle(this.np, newKey, newItem);
            }
            return null;
        }
    }
}

