/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.gitweb;

import com.google.common.io.ByteStreams;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.server.config.GitwebCgiConfig;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
class GitwebJavaScriptServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final long modified;
    private final byte[] raw;

    @Inject
    GitwebJavaScriptServlet(GitwebCgiConfig gitwebCgiConfig) throws IOException {
        byte[] png;
        Path src = gitwebCgiConfig.getGitwebJs();
        if (src != null) {
            try (InputStream in = Files.newInputStream(src, new OpenOption[0]);){
                png = ByteStreams.toByteArray(in);
            }
            catch (NoSuchFileException e) {
                png = null;
            }
            this.modified = FileUtil.lastModified(src);
        } else {
            this.modified = -1L;
            png = null;
        }
        this.raw = png;
    }

    @Override
    protected long getLastModified(HttpServletRequest req) {
        return this.modified;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (this.raw != null) {
            rsp.setContentType("text/javascript");
            rsp.setContentLength(this.raw.length);
            rsp.setDateHeader("Last-Modified", this.modified);
            CacheHeaders.setCacheable(req, rsp, 5L, TimeUnit.MINUTES);
            try (ServletOutputStream os = rsp.getOutputStream();){
                os.write(this.raw);
            }
        } else {
            CacheHeaders.setNotCacheable(rsp);
            rsp.sendError(404);
        }
    }
}

