/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.common.base.Throwables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.httpd.rpc.project.ProjectAccessHandler;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ContributorAgreementsChecker;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.SetParent;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ReviewProjectAccess
extends ProjectAccessHandler<Change.Id> {
    private final ReviewDb db;
    private final PermissionBackend permissionBackend;
    private final Sequences seq;
    private final Provider<PostReviewers> reviewersProvider;
    private final ProjectCache projectCache;
    private final ChangesCollection changes;
    private final ChangeInserter.Factory changeInserterFactory;
    private final BatchUpdate.Factory updateFactory;

    @Inject
    ReviewProjectAccess(ProjectControl.Factory projectControlFactory, PermissionBackend permissionBackend, GroupBackend groupBackend, MetaDataUpdate.User metaDataUpdateFactory, ReviewDb db, Provider<PostReviewers> reviewersProvider, ProjectCache projectCache, AllProjectsName allProjects, ChangesCollection changes, ChangeInserter.Factory changeInserterFactory, BatchUpdate.Factory updateFactory, Provider<SetParent> setParent, Sequences seq, ContributorAgreementsChecker contributorAgreements, @Assisted(value="projectName") Project.NameKey projectName, @Nullable @Assisted ObjectId base, @Assisted List<AccessSection> sectionList, @Nullable @Assisted(value="parentProjectName") Project.NameKey parentProjectName, @Nullable @Assisted String message) {
        super(projectControlFactory, groupBackend, metaDataUpdateFactory, allProjects, setParent, projectName, base, sectionList, parentProjectName, message, contributorAgreements, false);
        this.db = db;
        this.permissionBackend = permissionBackend;
        this.seq = seq;
        this.reviewersProvider = reviewersProvider;
        this.projectCache = projectCache;
        this.changes = changes;
        this.changeInserterFactory = changeInserterFactory;
        this.updateFactory = updateFactory;
    }

    @Override
    protected Change.Id updateProjectConfig(ProjectControl projectControl, ProjectConfig config, MetaDataUpdate md, boolean parentProjectUpdate) throws IOException, OrmException, PermissionDeniedException, PermissionBackendException {
        ChangeResource rsrc;
        PermissionBackend.ForRef metaRef = this.permissionBackend.user(projectControl.getUser()).project(projectControl.getProject().getNameKey()).ref("refs/meta/config");
        try {
            metaRef.check(RefPermission.READ);
        }
        catch (AuthException denied) {
            throw new PermissionDeniedException("refs/meta/config not visible");
        }
        if (!projectControl.isOwner()) {
            try {
                metaRef.check(RefPermission.CREATE_CHANGE);
            }
            catch (AuthException denied) {
                throw new PermissionDeniedException("cannot create change for refs/meta/config");
            }
        }
        md.setInsertChangeId(true);
        Change.Id changeId = new Change.Id(this.seq.nextChangeId());
        RevCommit commit = config.commitToNewRef(md, new PatchSet.Id(changeId, 1).toRefName());
        if (commit.getId().equals(this.base)) {
            return null;
        }
        try (ObjectInserter objInserter = md.getRepository().newObjectInserter();
             ObjectReader objReader = objInserter.newReader();
             RevWalk rw = new RevWalk(objReader);
             BatchUpdate bu = this.updateFactory.create(this.db, config.getProject().getNameKey(), projectControl.getUser(), TimeUtil.nowTs());){
            bu.setRepository(md.getRepository(), rw, objInserter);
            bu.insertChange(this.changeInserterFactory.create(changeId, commit, "refs/meta/config").setValidate(false).setUpdateRef(false));
            bu.execute();
        }
        catch (RestApiException | UpdateException e) {
            throw new IOException(e);
        }
        try {
            rsrc = this.changes.parse(changeId);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException(e);
        }
        this.addProjectOwnersAsReviewers(rsrc);
        if (parentProjectUpdate) {
            this.addAdministratorsAsReviewers(rsrc);
        }
        return changeId;
    }

    private void addProjectOwnersAsReviewers(ChangeResource rsrc) {
        String projectOwners = this.groupBackend.get(SystemGroupBackend.PROJECT_OWNERS).getName();
        try {
            AddReviewerInput input = new AddReviewerInput();
            input.reviewer = projectOwners;
            this.reviewersProvider.get().apply(rsrc, input);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
        }
    }

    private void addAdministratorsAsReviewers(ChangeResource rsrc) {
        List<PermissionRule> adminRules = this.projectCache.getAllProjects().getConfig().getAccessSection("GLOBAL_CAPABILITIES").getPermission("administrateServer").getRules();
        for (PermissionRule r : adminRules) {
            try {
                AddReviewerInput input = new AddReviewerInput();
                input.reviewer = r.getGroup().getUUID().get();
                this.reviewersProvider.get().apply(rsrc, input);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
            }
        }
    }

    static interface Factory {
        public ReviewProjectAccess create(@Assisted(value="projectName") Project.NameKey var1, @Nullable @Assisted ObjectId var2, @Assisted List<AccessSection> var3, @Nullable @Assisted(value="parentProjectName") Project.NameKey var4, @Nullable @Assisted String var5);
    }
}

