/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.query.DataSource;
import com.google.gerrit.index.query.Paginated;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.Collection;
import java.util.List;

public class IndexedQuery<I, T>
extends Predicate<T>
implements DataSource<T>,
Paginated<T> {
    protected final Index<I, T> index;
    private QueryOptions opts;
    private final Predicate<T> pred;
    protected DataSource<T> source;

    public IndexedQuery(Index<I, T> index, Predicate<T> pred, QueryOptions opts) throws QueryParseException {
        this.index = index;
        this.opts = opts;
        this.pred = pred;
        this.source = index.getSource(pred, this.opts);
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Predicate<T> getChild(int i) {
        if (i == 0) {
            return this.pred;
        }
        throw new ArrayIndexOutOfBoundsException(i);
    }

    @Override
    public List<Predicate<T>> getChildren() {
        return ImmutableList.of(this.pred);
    }

    @Override
    public QueryOptions getOptions() {
        return this.opts;
    }

    @Override
    public int getCardinality() {
        return this.source != null ? this.source.getCardinality() : this.opts.limit();
    }

    @Override
    public ResultSet<T> read() throws OrmException {
        return this.source.read();
    }

    @Override
    public ResultSet<T> restart(int start) throws OrmException {
        this.opts = this.opts.withStart(start);
        try {
            this.source = this.index.getSource(this.pred, this.opts);
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
        return this.read();
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        return this;
    }

    @Override
    public int hashCode() {
        return this.pred.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexedQuery o = (IndexedQuery)other;
        return this.pred.equals(o.pred) && this.opts.equals(o.opts);
    }

    public String toString() {
        return MoreObjects.toStringHelper("index").add("p", this.pred).add("opts", this.opts).toString();
    }
}

